/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.compile.transformers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.kframework.compile.utils.MaudeHelper;
import org.kframework.compile.utils.MetaK;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Attributes;
import org.kframework.kil.Cell;
import org.kframework.kil.Collection;
import org.kframework.kil.CollectionBuiltin;
import org.kframework.kil.CollectionItem;
import org.kframework.kil.Freezer;
import org.kframework.kil.FreezerLabel;
import org.kframework.kil.KApp;
import org.kframework.kil.KInjectedLabel;
import org.kframework.kil.KLabel;
import org.kframework.kil.KLabelConstant;
import org.kframework.kil.KList;
import org.kframework.kil.KSequence;
import org.kframework.kil.ListTerminator;
import org.kframework.kil.MapBuiltin;
import org.kframework.kil.MapItem;
import org.kframework.kil.Module;
import org.kframework.kil.Production;
import org.kframework.kil.ProductionItem;
import org.kframework.kil.Sort;
import org.kframework.kil.Syntax;
import org.kframework.kil.Term;
import org.kframework.kil.TermCons;
import org.kframework.kil.Terminal;
import org.kframework.kil.UserList;
import org.kframework.kil.Variable;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.CopyOnWriteTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.krun.K;
import org.kframework.utils.general.GlobalSettings;

public class FlattenSyntax
extends CopyOnWriteTransformer {
    FlattenKSyntax kTrans;
    Set<String> listSeparators = new HashSet<String>();
    boolean isComputation = false;

    public FlattenSyntax(Context context) {
        super("Syntax K to Abstract K", context);
        this.kTrans = new FlattenKSyntax(this, context);
    }

    @Override
    public ASTNode transform(Module node) throws TransformerException {
        this.listSeparators.clear();
        node = (Module)super.transform(node);
        if (this.listSeparators.isEmpty()) {
            return node;
        }
        for (String sep : this.listSeparators) {
            node.addConstant("KLabel", MetaK.getListUnitLabel(sep));
        }
        return node;
    }

    @Override
    public ASTNode transform(Syntax node) throws TransformerException {
        if (!MetaK.isComputationSort(node.getSort().getName())) {
            this.isComputation = false;
            return super.transform(node);
        }
        this.isComputation = true;
        node = (Syntax)super.transform(node);
        node.setSort(new Sort("KLabel"));
        return node;
    }

    @Override
    public ASTNode transform(Production node) throws TransformerException {
        if (node.containsAttribute("KLabelWrapper")) {
            return node;
        }
        if (!this.isComputation) {
            return super.transform(node);
        }
        if (node.isSubsort() && !node.containsAttribute("klabel")) {
            return null;
        }
        String arity = String.valueOf(node.getArity());
        Attributes attrs = node.getAttributes().shallowCopy();
        if (node.isListDecl()) {
            this.listSeparators.add(((UserList)node.getItems().get(0)).getSeparator());
            attrs.set("hybrid", "");
        }
        node = node.shallowCopy();
        ArrayList<ProductionItem> pis = new ArrayList<ProductionItem>();
        pis.add(new Terminal(node.getKLabel()));
        node.setItems(pis);
        attrs.set("arity", arity);
        node.setAttributes(attrs);
        node.setSort("KLabel");
        return node;
    }

    @Override
    public ASTNode transform(Sort node) throws TransformerException {
        if (!MetaK.isComputationSort(node.getName())) {
            return node;
        }
        return new Sort("K");
    }

    @Override
    public ASTNode transform(KApp node) throws TransformerException {
        return node.accept(this.kTrans);
    }

    @Override
    public ASTNode transform(KSequence node) throws TransformerException {
        return node.accept(this.kTrans);
    }

    @Override
    public ASTNode transform(Variable node) throws TransformerException {
        if (MetaK.isComputationSort(node.getSort())) {
            return node.accept(this.kTrans);
        }
        return node;
    }

    @Override
    public ASTNode transform(ListTerminator node) throws TransformerException {
        if (MetaK.isComputationSort(node.getSort())) {
            return node.accept(this.kTrans);
        }
        return node;
    }

    @Override
    public ASTNode transform(TermCons tc) throws TransformerException {
        if (MetaK.isComputationSort(tc.getSort())) {
            return tc.accept(this.kTrans);
        }
        return super.transform(tc);
    }

    class FlattenKSyntax
    extends CopyOnWriteTransformer {
        FlattenSyntax trans;

        public FlattenKSyntax(FlattenSyntax t, Context context) {
            super("Flatten K Syntax", context);
            this.trans = t;
        }

        @Override
        public ASTNode transform(KApp node) throws TransformerException {
            Term label = (Term)node.getLabel().accept(this.trans);
            Term child = (Term)node.getChild().accept(this.trans);
            if (child != node.getChild() || label != node.getLabel()) {
                node = node.shallowCopy();
                node.setChild(child);
                node.setLabel(label);
            }
            return node;
        }

        @Override
        public ASTNode transform(Freezer node) throws TransformerException {
            return KApp.of(new FreezerLabel((Term)node.getTerm().accept(this)), new Term[0]);
        }

        @Override
        public ASTNode transform(TermCons tc) throws TransformerException {
            if (!MetaK.isComputationSort(tc.getSort())) {
                return KApp.of(new KInjectedLabel((Term)tc.accept(this.trans)), new Term[0]);
            }
            String l = tc.getLocation();
            String f = tc.getFilename();
            Production ppp = (Production)this.context.conses.get(tc.getCons());
            KList lok = new KList(l, f);
            for (Term t : tc.getContents()) {
                lok.getContents().add((Term)t.accept(this));
            }
            return new KApp(l, f, KLabelConstant.of(ppp.getKLabel(), this.context), lok);
        }

        @Override
        public ASTNode transform(KLabel kLabel) throws TransformerException {
            return new KApp(kLabel.getLocation(), kLabel.getFilename(), new KInjectedLabel(kLabel), KList.EMPTY);
        }

        @Override
        public ASTNode transform(ListTerminator emp) {
            String l = emp.getLocation();
            String f = emp.getFilename();
            if (!MetaK.isComputationSort(emp.getSort())) {
                return KApp.of(new KInjectedLabel(emp), new Term[0]);
            }
            if (!MaudeHelper.basicSorts.contains(emp.getSort())) {
                Production listProd = this.context.listConses.get(emp.getSort());
                String separator = ((UserList)listProd.getItems().get(0)).getSeparator();
                return new KApp(l, f, KLabelConstant.of(MetaK.getListUnitLabel(separator), this.context), KList.EMPTY);
            }
            return emp;
        }

        @Override
        public ASTNode transform(Collection node) throws TransformerException {
            if (node instanceof KSequence) {
                return super.transform(node);
            }
            return KApp.of(new KInjectedLabel((Term)node.accept(this.trans)), new Term[0]);
        }

        @Override
        public ASTNode transform(CollectionItem node) throws TransformerException {
            return KApp.of(new KInjectedLabel((Term)node.accept(this.trans)), new Term[0]);
        }

        @Override
        public ASTNode transform(MapItem node) throws TransformerException {
            return KApp.of(new KInjectedLabel((Term)node.accept(this.trans)), new Term[0]);
        }

        @Override
        public ASTNode transform(CollectionBuiltin node) throws TransformerException {
            assert (node.isLHSView() || node.isElementCollection());
            LinkedHashSet<Term> elements = new LinkedHashSet<Term>(node.elements().size());
            for (Term term : node.elements()) {
                Term transformedTerm = (Term)term.accept(this.trans);
                elements.add(transformedTerm);
            }
            ArrayList<Term> terms = new ArrayList<Term>(node.baseTerms().size());
            if (node.isLHSView()) {
                Variable frame = node.viewBase();
                frame.setSort(node.sort().type());
                terms.add(frame);
            }
            return KApp.of(new KInjectedLabel(CollectionBuiltin.of(node.sort(), terms, elements)), new Term[0]);
        }

        @Override
        public ASTNode transform(MapBuiltin node) throws TransformerException {
            assert (node.isLHSView() || node.isElementCollection());
            LinkedHashMap<Term, Term> elements = new LinkedHashMap<Term, Term>(node.elements().size());
            for (Map.Entry<Term, Term> entry : node.elements().entrySet()) {
                Term transformedKey = (Term)entry.getKey().accept(this.trans);
                Term transformedValue = (Term)entry.getValue().accept(this.trans);
                elements.put(transformedKey, transformedValue);
            }
            ArrayList<Term> terms = new ArrayList<Term>(node.baseTerms().size());
            if (node.isLHSView()) {
                Variable frame = node.viewBase();
                frame.setSort(node.sort().type());
                terms.add(frame);
            }
            return KApp.of(new KInjectedLabel(new MapBuiltin(node.sort(), terms, elements)), new Term[0]);
        }

        @Override
        public ASTNode transform(Cell node) throws TransformerException {
            return KApp.of(new KInjectedLabel((Term)node.accept(this.trans)), new Term[0]);
        }

        @Override
        public ASTNode transform(Variable node) throws TransformerException {
            if (node.getSort().equals("KItem") || node.getSort().equals("K")) {
                return node;
            }
            if (MetaK.isKSort(node.getSort())) {
                return KApp.of(new KInjectedLabel(node), new Term[0]);
            }
            if (node.getSort().equals("#Bool") || node.getSort().equals("#Int") || node.getSort().equals("#Float") || node.getSort().equals("#String")) {
                return node;
            }
            if (this.context.getDataStructureSorts().containsKey(node.getSort())) {
                return node;
            }
            node = node.shallowCopy();
            if (!GlobalSettings.javaBackend && !K.backend.equals("java")) {
                node.setSort("KItem");
            }
            return node;
        }
    }
}

