/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.compile.transformers;

import java.util.ArrayList;
import java.util.List;
import org.kframework.compile.transformers.ContextsToHeating;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Configuration;
import org.kframework.kil.Context;
import org.kframework.kil.Freezer;
import org.kframework.kil.KSequence;
import org.kframework.kil.Rewrite;
import org.kframework.kil.Rule;
import org.kframework.kil.Syntax;
import org.kframework.kil.Term;
import org.kframework.kil.visitors.CopyOnWriteTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.utils.errorsystem.KException;
import org.kframework.utils.general.GlobalSettings;

public class FreezeUserFreezers
extends CopyOnWriteTransformer {
    public FreezeUserFreezers(org.kframework.kil.loader.Context context) {
        super("Freeze User Freezers", context);
    }

    @Override
    public ASTNode transform(Configuration node) throws TransformerException {
        return node;
    }

    @Override
    public ASTNode transform(Context node) throws TransformerException {
        return node;
    }

    @Override
    public ASTNode transform(Rule node) throws TransformerException {
        Term freezer;
        KSequence kSequence;
        boolean heating = node.containsAttribute("heat");
        boolean cooling = node.containsAttribute("cool");
        if (!heating && !cooling) {
            return node;
        }
        if (!(node.getBody() instanceof Rewrite)) {
            GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, "Heating/Cooling rules should have rewrite at the top.", this.getName(), node.getFilename(), node.getLocation()));
        }
        Rewrite rewrite = (Rewrite)node.getBody();
        if (heating) {
            if (!(rewrite.getRight() instanceof KSequence)) {
                GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, "Heating rules should have a K sequence in the rhs.", this.getName(), node.getFilename(), node.getLocation()));
            }
            kSequence = (KSequence)rewrite.getRight();
        } else {
            if (!(rewrite.getLeft() instanceof KSequence)) {
                GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, "Cooling rules should have a K sequence in the lhs.", this.getName(), node.getFilename(), node.getLocation()));
            }
            kSequence = (KSequence)rewrite.getLeft();
        }
        List<Term> kSequenceContents = kSequence.getContents();
        if (kSequenceContents.size() != 2) {
            GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, "Heating/Cooling rules should have exactly 2 items in their K Sequence.", this.getName(), node.getFilename(), node.getLocation()));
        }
        if (!((freezer = kSequenceContents.get(1)) instanceof Freezer)) {
            kSequenceContents = new ArrayList<Term>(kSequenceContents);
            kSequenceContents.set(1, new ContextsToHeating(this.context).freeze(freezer));
            kSequence = kSequence.shallowCopy();
            kSequence.setContents(kSequenceContents);
            rewrite = rewrite.shallowCopy();
            if (heating) {
                rewrite.replaceChildren(rewrite.getLeft(), kSequence, this.context);
            } else {
                rewrite.replaceChildren(kSequence, rewrite.getRight(), this.context);
            }
            node = node.shallowCopy();
            node.setBody(rewrite);
        }
        return node;
    }

    @Override
    public ASTNode transform(Syntax node) throws TransformerException {
        return node;
    }
}

