/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.compile.transformers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.kframework.compile.utils.Substitution;
import org.kframework.kil.ASTNode;
import org.kframework.kil.BoolBuiltin;
import org.kframework.kil.Sentence;
import org.kframework.kil.Term;
import org.kframework.kil.TermCons;
import org.kframework.kil.Variable;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.CopyOnWriteTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.utils.errorsystem.KException;
import org.kframework.utils.general.GlobalSettings;

public class FreshCondToFreshVar
extends CopyOnWriteTransformer {
    private Set<Variable> vars = new HashSet<Variable>();

    public FreshCondToFreshVar(Context context) {
        super("Transform fresh conditions into fresh variables.", context);
    }

    @Override
    public ASTNode transform(Sentence node) throws TransformerException {
        if (null == node.getRequires()) {
            return node;
        }
        this.vars.clear();
        ASTNode condNode = node.getRequires().accept(this);
        if (this.vars.isEmpty()) {
            return node;
        }
        node = node.shallowCopy();
        node.setRequires((Term)condNode);
        ASTNode bodyNode = node.getBody().accept(this.freshSubstitution(this.vars));
        assert (bodyNode instanceof Term);
        node.setBody((Term)bodyNode);
        return node;
    }

    @Override
    public ASTNode transform(TermCons node) throws TransformerException {
        if ("Bool1FreshSyn".equals(node.getCons())) {
            if (node.getContents().size() != 1) {
                GlobalSettings.kem.register(new KException(KException.ExceptionType.WARNING, KException.KExceptionGroup.COMPILER, "Fresh has more than one argument:" + node, this.getName(), node.getFilename(), node.getLocation()));
            }
            if (!(node.getContents().get(0) instanceof Variable)) {
                GlobalSettings.kem.register(new KException(KException.ExceptionType.WARNING, KException.KExceptionGroup.COMPILER, "Fresh must take a variable as argument:" + node, this.getName(), node.getFilename(), node.getLocation()));
            }
            Variable var = (Variable)node.getContents().get(0);
            this.vars.add(var);
            return BoolBuiltin.TRUE;
        }
        return super.transform(node);
    }

    private Substitution freshSubstitution(Set<Variable> vars) {
        HashMap<Term, Term> symMap = new HashMap<Term, Term>();
        for (Variable var : vars) {
            Variable freshVar = var.shallowCopy();
            freshVar.setFresh(true);
            symMap.put(var, freshVar);
        }
        return new Substitution(symMap, this.context);
    }
}

