/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.compile.transformers;

import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kframework.compile.transformers.AddPredicates;
import org.kframework.compile.utils.MetaK;
import org.kframework.compile.utils.SyntaxByTag;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Attribute;
import org.kframework.kil.BoolBuiltin;
import org.kframework.kil.IntBuiltin;
import org.kframework.kil.KApp;
import org.kframework.kil.KInjectedLabel;
import org.kframework.kil.KLabelConstant;
import org.kframework.kil.KList;
import org.kframework.kil.Module;
import org.kframework.kil.ModuleItem;
import org.kframework.kil.Production;
import org.kframework.kil.Rule;
import org.kframework.kil.Term;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.CopyOnWriteTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.utils.general.GlobalSettings;

public class ResolveBinder
extends CopyOnWriteTransformer {
    private static final KLabelConstant BINDER_PREDICATE = KLabelConstant.of(AddPredicates.predicate("Binder"));
    private static final KLabelConstant BOUNDED_PREDICATE = KLabelConstant.of(AddPredicates.predicate("Bound"));
    private static final KLabelConstant BOUNDING_PREDICATE = KLabelConstant.of(AddPredicates.predicate("Bounding"));
    private static final String REGEX = "\\s*(\\d+)(\\s*-\\>\\s*(\\d+))?\\s*(,?)";

    public ResolveBinder(Context context) {
        super("Resolve binder", context);
    }

    @Override
    public ASTNode transform(Module node) throws TransformerException {
        Set<Production> prods = SyntaxByTag.get(node, "binder", this.context);
        if (prods.isEmpty()) {
            return node;
        }
        ArrayList<ModuleItem> items = new ArrayList<ModuleItem>(node.getItems());
        node = node.shallowCopy();
        node.setItems(items);
        for (Production prod : prods) {
            KList list;
            String bindInfo = prod.getAttribute("binder");
            if (bindInfo == null || bindInfo.equals("")) {
                bindInfo = "1->" + prod.getArity();
            }
            Pattern p = Pattern.compile(REGEX);
            Matcher m = p.matcher(bindInfo);
            HashMultimap<Integer, Integer> bndMap = HashMultimap.create();
            while (m.regionStart() < m.regionEnd()) {
                if (!m.lookingAt()) {
                    System.err.println("[error:] could not parse binder attribute \"" + bindInfo.substring(m.regionStart(), m.regionEnd()) + "\"");
                    System.exit(1);
                }
                if (m.end() < m.regionEnd()) {
                    if (!m.group(4).equals(",")) {
                        System.err.println("[error:] expecting ',' at the end \"" + m.group() + "\"");
                        System.exit(1);
                    }
                } else if (!m.group(4).equals("")) {
                    System.err.println("[error:] unexpected ',' at the end \"" + m.group() + "\"");
                    System.exit(1);
                }
                int bndIdx = Integer.parseInt(m.group(1));
                if (m.group(3) == null) {
                    for (int idx = 1; idx <= prod.getArity(); ++idx) {
                        if (idx == bndIdx) continue;
                        bndMap.put(bndIdx, idx);
                    }
                } else {
                    bndMap.put(bndIdx, Integer.parseInt(m.group(3)));
                }
                m.region(m.end(), m.regionEnd());
            }
            prod.setBinderMap(bndMap);
            if (GlobalSettings.javaBackend) continue;
            Rule rule = new Rule(KApp.of(BINDER_PREDICATE, MetaK.getTerm(prod, this.context)), BoolBuiltin.TRUE, this.context);
            rule.addAttribute(Attribute.ANYWHERE);
            items.add(rule);
            KApp klblK = KApp.of(new KInjectedLabel(KLabelConstant.of(prod.getKLabel())), new Term[0]);
            Iterator<Object> i$ = bndMap.keySet().iterator();
            while (i$.hasNext()) {
                int bndIdx = (Integer)i$.next();
                list = new KList();
                list.getContents().add(klblK);
                list.getContents().add(IntBuiltin.kAppOf(bndIdx));
                rule = new Rule(new KApp(BOUNDED_PREDICATE, list), BoolBuiltin.TRUE, this.context);
                rule.addAttribute(Attribute.ANYWHERE);
                items.add(rule);
                String bndSort = prod.getChildSort(bndIdx - 1);
            }
            i$ = bndMap.values().iterator();
            while (i$.hasNext()) {
                int bodyIdx = (Integer)i$.next();
                list = new KList();
                list.getContents().add(klblK);
                list.getContents().add(IntBuiltin.kAppOf(bodyIdx));
                rule = new Rule(new KApp(BOUNDING_PREDICATE, list), BoolBuiltin.TRUE, this.context);
                rule.addAttribute(Attribute.ANYWHERE);
                items.add(rule);
            }
        }
        return node;
    }
}

