/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.compile.transformers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kframework.compile.utils.GetLhsPattern;
import org.kframework.compile.utils.MetaK;
import org.kframework.kil.ASTNode;
import org.kframework.kil.BoolBuiltin;
import org.kframework.kil.Cell;
import org.kframework.kil.Configuration;
import org.kframework.kil.Context;
import org.kframework.kil.DataStructureSort;
import org.kframework.kil.Definition;
import org.kframework.kil.KApp;
import org.kframework.kil.KLabelConstant;
import org.kframework.kil.KList;
import org.kframework.kil.ListItem;
import org.kframework.kil.Module;
import org.kframework.kil.Rewrite;
import org.kframework.kil.Rule;
import org.kframework.kil.StringBuiltin;
import org.kframework.kil.Syntax;
import org.kframework.kil.Term;
import org.kframework.kil.Variable;
import org.kframework.kil.visitors.BasicVisitor;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.utils.errorsystem.KException;
import org.kframework.utils.general.GlobalSettings;

public class ResolveBlockingInput
extends GetLhsPattern {
    Map<String, String> inputCells = new HashMap<String, String>();
    List<Rule> generated = new ArrayList<Rule>();
    boolean hasInputCell;
    Term resultCondition;
    boolean newList;
    private static final KLabelConstant parseInputLabel = KLabelConstant.of("#parseInput");
    private static final KLabelConstant bufferLabel = KLabelConstant.of("#buffer");

    public ResolveBlockingInput(org.kframework.kil.loader.Context context, boolean newList) {
        super("Resolve Blocking Input", context);
        this.newList = newList;
    }

    @Override
    public ASTNode transform(Definition node) throws TransformerException {
        Configuration config = MetaK.getConfiguration(node, this.context);
        config.accept(new BasicVisitor(this.context){

            @Override
            public void visit(Cell node) {
                String stream = node.getCellAttributes().get("stream");
                if ("stdin".equals(stream)) {
                    String delimiter = node.getCellAttributes().get("delimiters");
                    if (delimiter == null) {
                        delimiter = " \n\t\r";
                    }
                    ResolveBlockingInput.this.inputCells.put(node.getLabel(), delimiter);
                }
                super.visit(node);
            }
        });
        return super.transform(node);
    }

    @Override
    public ASTNode transform(Module node) throws TransformerException {
        ASTNode result = super.transform(node);
        if (result != node) {
            GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.INTERNAL, "Should have obtained the same module.", this.getName(), node.getFilename(), node.getLocation()));
        }
        if (this.generated.isEmpty()) {
            return node;
        }
        node = node.shallowCopy();
        node.getItems().addAll(this.generated);
        return node;
    }

    @Override
    public ASTNode transform(Configuration node) throws TransformerException {
        return node;
    }

    @Override
    public ASTNode transform(Context node) throws TransformerException {
        return node;
    }

    @Override
    public ASTNode transform(Syntax node) throws TransformerException {
        return node;
    }

    @Override
    public ASTNode transform(Rule node) throws TransformerException {
        this.hasInputCell = false;
        if (node.getAttributes().containsKey("stdin")) {
            return node;
        }
        ASTNode result = super.transform(node);
        if (this.hasInputCell) {
            this.generated.add((Rule)result);
            node.setRequires(MetaK.incrementCondition(node.getRequires(), this.resultCondition));
        }
        return node;
    }

    @Override
    public ASTNode transform(Cell node) throws TransformerException {
        Term list;
        Term variable;
        if (!this.inputCells.containsKey(node.getLabel())) {
            return super.transform(node);
        }
        if (node.getEllipses() != Cell.Ellipses.RIGHT) {
            GlobalSettings.kem.register(new KException(KException.ExceptionType.WARNING, KException.KExceptionGroup.COMPILER, "cell should have right ellipses but it doesn't." + System.getProperty("line.separator") + "Won't transform.", this.getName(), node.getFilename(), node.getLocation()));
            return node;
        }
        Term contents = node.getContents();
        if (!(contents instanceof Rewrite)) {
            GlobalSettings.kem.register(new KException(KException.ExceptionType.WARNING, KException.KExceptionGroup.COMPILER, "Expecting a rewrite of a basic type variable into the empty list but got " + contents.getClass() + "." + System.getProperty("line.separator") + "Won't transform.", this.getName(), contents.getFilename(), contents.getLocation()));
            return node;
        }
        Rewrite rewrite = (Rewrite)contents;
        if (!this.newList && !(rewrite.getLeft() instanceof ListItem) || this.newList && (!(rewrite.getLeft() instanceof KApp) || !((KApp)rewrite.getLeft()).getLabel().equals(KLabelConstant.of("'MyListItem", this.context)))) {
            GlobalSettings.kem.register(new KException(KException.ExceptionType.WARNING, KException.KExceptionGroup.COMPILER, "Expecting a list item but got " + rewrite.getLeft().getClass() + "." + System.getProperty("line.separator") + "Won't transform.", this.getName(), rewrite.getLeft().getFilename(), rewrite.getLeft().getLocation()));
            return node;
        }
        Term item = rewrite.getLeft();
        if (this.newList) {
            KApp kappItem = (KApp)item;
            Term child = kappItem.getChild();
            if (!(child instanceof KList) || ((KList)child).getContents().size() != 1) {
                GlobalSettings.kem.register(new KException(KException.ExceptionType.WARNING, KException.KExceptionGroup.COMPILER, "Expecting an input type variable but got a KList instead. Won't transform.", this.getName(), ((KApp)item).getChild().getFilename(), ((KApp)item).getChild().getLocation()));
                return node;
            }
            variable = ((KList)child).getContents().get(0);
        } else {
            variable = ((ListItem)item).getItem();
        }
        if (!(variable instanceof Variable)) {
            GlobalSettings.kem.register(new KException(KException.ExceptionType.WARNING, KException.KExceptionGroup.COMPILER, "Expecting an input type variable but got " + variable.getClass() + "." + System.getProperty("line.separator") + "Won't transform.", this.getName(), variable.getFilename(), variable.getLocation()));
            return node;
        }
        if (!((this.newList || rewrite.getRight() instanceof org.kframework.kil.List && ((org.kframework.kil.List)rewrite.getRight()).isEmpty()) && (!this.newList || rewrite.getRight() instanceof KApp && ((KApp)rewrite.getRight()).getLabel().equals(KLabelConstant.of("'.MyList", this.context))))) {
            GlobalSettings.kem.register(new KException(KException.ExceptionType.WARNING, KException.KExceptionGroup.COMPILER, "Expecting an empty list but got " + rewrite.getRight().getClass() + " of sort " + rewrite.getRight().getSort() + "." + System.getProperty("line.separator") + "Won't transform.", this.getName(), rewrite.getRight().getFilename(), rewrite.getRight().getLocation()));
            return node;
        }
        this.hasInputCell = true;
        this.resultCondition = this.getPredicateTerm((Variable)variable);
        KApp parseTerm = KApp.of(parseInputLabel, StringBuiltin.kAppOf(variable.getSort()), StringBuiltin.kAppOf(this.inputCells.get(node.getLabel())));
        KApp ioBuffer = KApp.of(bufferLabel, new Variable(Variable.getFreshVar("K")));
        if (this.newList) {
            DataStructureSort myList = this.context.dataStructureListSortOf("MyList");
            Rewrite term1 = new Rewrite(KApp.of(KLabelConstant.of(myList.unitLabel(), this.context), new Term[0]), KApp.of(KLabelConstant.of(myList.elementLabel(), this.context), parseTerm), this.context);
            KApp term2 = KApp.of(KLabelConstant.of(myList.elementLabel(), this.context), ioBuffer);
            list = KApp.of(KLabelConstant.of(myList.constructorLabel(), this.context), term1, term2);
        } else {
            list = new org.kframework.kil.List();
            list.getContents().add(new Rewrite(org.kframework.kil.List.EMPTY, new ListItem(parseTerm), this.context));
            list.getContents().add(new ListItem(ioBuffer));
        }
        node = node.shallowCopy();
        node.setContents(list);
        return node;
    }

    private Term getPredicateTerm(Variable var) {
        return KApp.of(KLabelConstant.KNEQ_KLABEL, KApp.of(KLabelConstant.STREAM_PREDICATE, var), BoolBuiltin.TRUE);
    }
}

