/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.compile.transformers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.kframework.compile.transformers.AddPredicates;
import org.kframework.compile.utils.MetaK;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Attribute;
import org.kframework.kil.BoolBuiltin;
import org.kframework.kil.Configuration;
import org.kframework.kil.Context;
import org.kframework.kil.KApp;
import org.kframework.kil.KLabelConstant;
import org.kframework.kil.Module;
import org.kframework.kil.ModuleItem;
import org.kframework.kil.PriorityBlock;
import org.kframework.kil.Production;
import org.kframework.kil.ProductionItem;
import org.kframework.kil.Rewrite;
import org.kframework.kil.Rule;
import org.kframework.kil.Sort;
import org.kframework.kil.Syntax;
import org.kframework.kil.Terminal;
import org.kframework.kil.Variable;
import org.kframework.kil.visitors.CopyOnWriteTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;

public class ResolveBuiltins
extends CopyOnWriteTransformer {
    Set<String> builtinSorts = new HashSet<String>();

    public ResolveBuiltins(org.kframework.kil.loader.Context context) {
        super("Resolve Builtins", context);
    }

    @Override
    public ASTNode transform(Module node) throws TransformerException {
        this.builtinSorts.clear();
        super.transform(node);
        if (this.builtinSorts.isEmpty()) {
            return node;
        }
        node = node.shallowCopy();
        ArrayList<ModuleItem> items = new ArrayList<ModuleItem>(node.getItems());
        ArrayList<PriorityBlock> priorities = new ArrayList<PriorityBlock>();
        PriorityBlock block = new PriorityBlock();
        priorities.add(block);
        Syntax syn = new Syntax(new Sort("KLabel"), priorities);
        items.add(syn);
        for (String sort : this.builtinSorts) {
            ArrayList<ProductionItem> pItems = new ArrayList<ProductionItem>();
            Production p = new Production(new Sort("KLabel"), pItems);
            pItems.add(new Terminal("#"));
            pItems.add(new Sort(sort));
            p.putAttribute("KLabelWrapper", sort);
            p.putAttribute("cons", "KLabel1" + sort + "Wrapper");
            p.putAttribute("prefixlabel", "#_");
            this.context.conses.put("KLabel1" + sort + "Wrapper", p);
            this.context.putLabel(p, "KLabel1" + sort + "Wrapper");
            block.getProductions().add(p);
            pItems = new ArrayList();
            p = new Production(new Sort("KLabel"), pItems);
            pItems.add(new Terminal("is" + sort));
            block.getProductions().add(p);
            Rule rule = new Rule();
            rule.setBody(new Rewrite(KApp.of(KLabelConstant.of(AddPredicates.predicate(sort), this.context), new Variable(sort, sort)), BoolBuiltin.TRUE, this.context));
            rule.addAttribute(Attribute.PREDICATE);
            items.add(rule);
        }
        node.setItems(items);
        return node;
    }

    @Override
    public ASTNode transform(Sort node) throws TransformerException {
        if (MetaK.isBuiltinSort(node.getName())) {
            this.builtinSorts.add(node.getName());
        }
        return node;
    }

    @Override
    public ASTNode transform(Configuration node) throws TransformerException {
        return node;
    }

    @Override
    public ASTNode transform(Context node) throws TransformerException {
        return node;
    }

    @Override
    public ASTNode transform(Rule node) throws TransformerException {
        return node;
    }
}

