/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.compile.transformers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.kframework.compile.utils.ConfigurationStructure;
import org.kframework.compile.utils.ConfigurationStructureMap;
import org.kframework.compile.utils.MetaK;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Bag;
import org.kframework.kil.Cell;
import org.kframework.kil.Configuration;
import org.kframework.kil.Context;
import org.kframework.kil.KLabelConstant;
import org.kframework.kil.Module;
import org.kframework.kil.Rewrite;
import org.kframework.kil.Rule;
import org.kframework.kil.Syntax;
import org.kframework.kil.Term;
import org.kframework.kil.TermCons;
import org.kframework.kil.Token;
import org.kframework.kil.Variable;
import org.kframework.kil.visitors.BasicVisitor;
import org.kframework.kil.visitors.CopyOnWriteTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.utils.errorsystem.KException;
import org.kframework.utils.general.GlobalSettings;

public class ResolveContextAbstraction
extends CopyOnWriteTransformer {
    private int maxLevel;
    private ConfigurationStructureMap config;

    public ResolveContextAbstraction(org.kframework.kil.loader.Context context) {
        super("Resolve Context Abstraction", context);
        this.config = context.getConfigurationStructureMap();
        this.maxLevel = context.getMaxConfigurationLevel();
    }

    @Override
    public ASTNode transform(Module node) throws TransformerException {
        if (this.config.isEmpty()) {
            return node;
        }
        return super.transform(node);
    }

    @Override
    public ASTNode transform(Configuration node) throws TransformerException {
        return node;
    }

    @Override
    public ASTNode transform(Syntax node) throws TransformerException {
        return node;
    }

    @Override
    public ASTNode transform(Context node) throws TransformerException {
        return node;
    }

    @Override
    public ASTNode transform(Rule node) throws TransformerException {
        if (MetaK.isAnywhere(node)) {
            return node;
        }
        boolean change = false;
        if (MetaK.getTopCells(node.getBody(), this.context).isEmpty()) {
            return node;
        }
        Rule rule = (Rule)super.transform(node);
        SplitByLevelVisitor visitor = new SplitByLevelVisitor(-1, this.context);
        rule.getBody().accept(visitor);
        int min = visitor.max;
        for (int i = visitor.max - 1; i > 0; --i) {
            if (visitor.levels.get(i).isEmpty()) continue;
            min = i;
        }
        if (min < visitor.max) {
            change = true;
        }
        Cell parentCell = null;
        do {
            LinkedList<Term> cells;
            if (min < visitor.max) {
                this.bringToLevel(visitor, min);
                visitor.max = min;
            }
            if (this.areMultipleCells(cells = visitor.levels.get(min))) {
                change = true;
            }
            ConfigurationStructure parent = this.findParent(cells.peek());
            parentCell = this.createParentCell(parent, cells);
            if (cells.isEmpty()) continue;
            if (min <= 1) {
                GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.COMPILER, "Got to the top cell while trying to fill up context for cell " + cells.peek() + ".  Perhaps missing a multiplicity declaration in configuration? ", this.getName(), node.getFilename(), node.getLocation()));
            }
            change = true;
            visitor.levels.get(--min).add(parentCell);
        } while (min < visitor.max);
        if (change) {
            rule = rule.shallowCopy();
            rule.setBody(parentCell);
        }
        return rule;
    }

    private boolean areMultipleCells(LinkedList<Term> cells) {
        if (cells.size() > 1) {
            return true;
        }
        if (cells.isEmpty()) {
            return false;
        }
        Term trm = cells.element();
        if (trm instanceof Cell) {
            return false;
        }
        assert (trm instanceof Rewrite);
        Rewrite rew = (Rewrite)trm;
        Term left = rew.getLeft();
        Term right = rew.getRight();
        if (!(left instanceof Cell) || !(right instanceof Cell)) {
            return true;
        }
        return !((Cell)left).getId().equals(((Cell)right).getId());
    }

    @Override
    public ASTNode transform(Cell node) throws TransformerException {
        boolean change = false;
        Cell cell = (Cell)super.transform(node);
        if (cell.getEllipses() == Cell.Ellipses.NONE) {
            return cell;
        }
        ConfigurationStructure confCell = this.config.get(cell);
        if (confCell == null) {
            GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, "Cell " + cell.getLabel() + " is not part of the configuration ", this.getName(), node.getFilename(), node.getLocation()));
        }
        if (confCell.sons.isEmpty()) {
            return cell;
        }
        SplitByLevelVisitor visitor = new SplitByLevelVisitor(confCell.level, this.context);
        cell.getContents().accept(visitor);
        int min = 0;
        if (visitor.max > min) {
            change = true;
        }
        this.bringToLevel(visitor, min);
        LinkedList<Term> cells = visitor.levels.get(min);
        Cell parentCell = this.createParentCell(confCell, cells);
        assert (cells.isEmpty());
        if (change) {
            cell = parentCell;
        }
        return cell;
    }

    private void bringToLevel(SplitByLevelVisitor visitor, int level) {
        while (visitor.max > level) {
            LinkedList<Term> cells = visitor.levels.get(visitor.max);
            if (cells.isEmpty()) {
                visitor.max--;
                continue;
            }
            ConfigurationStructure parent = this.findParent(cells.peek());
            Cell parentCell = this.createParentCell(parent, cells);
            visitor.levels.get(visitor.max - 1).add(parentCell);
        }
    }

    private Cell createParentCell(ConfigurationStructure parent, LinkedList<Term> cells) {
        Cell p = new Cell();
        p.setLabel(parent.cell.getLabel());
        p.setId(parent.id);
        Bag contents = new Bag();
        ArrayList<Term> items = new ArrayList<Term>();
        contents.setContents(items);
        p.setContents(contents);
        Cell.Ellipses e = this.fillParentItems(parent, cells, items);
        p.setEllipses(e);
        return p;
    }

    private Cell.Ellipses fillParentItems(ConfigurationStructure parent, LinkedList<Term> cells, List<Term> items) {
        HashMap<String, ConfigurationStructure> potentialSons = new HashMap<String, ConfigurationStructure>(parent.sons);
        ListIterator i = cells.listIterator();
        while (i.hasNext()) {
            Term t = (Term)i.next();
            List<Cell> inCells = MetaK.getTopCells(t, this.context);
            boolean allAvailable = true;
            for (Cell cell : inCells) {
                if (potentialSons.containsKey(cell.getId())) continue;
                allAvailable = false;
                break;
            }
            if (!allAvailable) continue;
            for (Cell cell : inCells) {
                ConfigurationStructure cellCfg = (ConfigurationStructure)potentialSons.get(cell.getId());
                if (cellCfg == null) {
                    GlobalSettings.kem.register(new KException(KException.ExceptionType.HIDDENWARNING, KException.KExceptionGroup.INTERNAL, "Cell " + cell + " appears more than its multiplicity in " + t + ". \n\tTransformation: " + this.getName(), this.getName(), t.getFilename(), t.getLocation()));
                    continue;
                }
                if (cellCfg.multiplicity != Cell.Multiplicity.MAYBE && cellCfg.multiplicity != Cell.Multiplicity.ONE) continue;
                potentialSons.remove(cell.getId());
            }
            items.add(t);
            i.remove();
        }
        if (potentialSons.isEmpty()) {
            return Cell.Ellipses.NONE;
        }
        return Cell.Ellipses.BOTH;
    }

    private ConfigurationStructure findParent(Term t) {
        List<Cell> cells;
        if (t instanceof Cell) {
            return this.config.get((Cell)((Cell)t)).parent;
        }
        if (!(t instanceof Rewrite)) {
            GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.INTERNAL, "Expecting Rewrite, but got " + t.getClass() + " while " + this.getName(), this.getName(), t.getFilename(), t.getLocation()));
        }
        if ((cells = MetaK.getTopCells(t, this.context)).isEmpty()) {
            GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.INTERNAL, "Expecting some cells in here, but got none while " + this.getName(), this.getName(), t.getFilename(), t.getLocation()));
        }
        Iterator<Cell> i = cells.iterator();
        ConfigurationStructure parent = this.config.get((Cell)i.next()).parent;
        while (i.hasNext()) {
            if (parent == this.config.get((Cell)i.next()).parent) continue;
            GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.INTERNAL, "Not all cells " + cells + "have parent " + parent + " while " + this.getName(), this.getName(), t.getFilename(), t.getLocation()));
        }
        return parent;
    }

    private class SplitByLevelVisitor
    extends BasicVisitor {
        ArrayList<LinkedList<Term>> levels;
        private int level;
        private int max;

        public SplitByLevelVisitor(int level, org.kframework.kil.loader.Context context) {
            super(context);
            this.levels = new ArrayList(ResolveContextAbstraction.this.maxLevel - level + 1);
            for (int i = 0; i <= ResolveContextAbstraction.this.maxLevel - level; ++i) {
                this.levels.add(new LinkedList());
            }
            this.level = level + 1;
            this.max = 0;
        }

        @Override
        public void visit(Cell node) {
            int level = ((ResolveContextAbstraction)ResolveContextAbstraction.this).config.get((Cell)node).level - this.level;
            if (level < 0) {
                GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.INTERNAL, "Cell " + node + " Has a higher level than its parent.", this.getName(), node.getFilename(), node.getLocation()));
            }
            if (this.max < level) {
                this.max = level;
            }
            this.levels.get(level).add(node);
        }

        @Override
        public void visit(KLabelConstant node) {
            this.levels.get(0).add(node);
        }

        @Override
        public void visit(Token node) {
            this.levels.get(0).add(node);
        }

        @Override
        public void visit(TermCons node) {
            this.levels.get(0).add(node);
        }

        @Override
        public void visit(Variable node) {
            this.levels.get(0).add(node);
        }

        @Override
        public void visit(Rewrite node) {
            List<Cell> cells = MetaK.getTopCells(node, this.context);
            int level = 0;
            if (!cells.isEmpty()) {
                Iterator<Cell> i = cells.iterator();
                level = ((ResolveContextAbstraction)ResolveContextAbstraction.this).config.get((Cell)i.next()).level - this.level;
                if (level < 0) {
                    GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.INTERNAL, "Rewrite not at the right level in configuration", this.getName(), node.getFilename(), node.getLocation()));
                }
                if (this.max < level) {
                    this.max = level;
                }
                while (i.hasNext()) {
                    if (level == ((ResolveContextAbstraction)ResolveContextAbstraction.this).config.get((Cell)i.next()).level - this.level) continue;
                    GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.INTERNAL, "Expecting all cells in " + node + " to be at the same level when " + this.getName(), this.getName(), node.getFilename(), node.getLocation()));
                }
            }
            this.levels.get(level).add(node);
        }
    }
}

