/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.compile.transformers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kframework.compile.utils.ConfigurationStructure;
import org.kframework.compile.utils.MetaK;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Bag;
import org.kframework.kil.Cell;
import org.kframework.kil.Configuration;
import org.kframework.kil.Context;
import org.kframework.kil.Rewrite;
import org.kframework.kil.Rule;
import org.kframework.kil.Syntax;
import org.kframework.kil.Term;
import org.kframework.kil.visitors.CopyOnWriteTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.utils.errorsystem.KException;
import org.kframework.utils.general.GlobalSettings;

public class ResolveDefaultTerms
extends CopyOnWriteTransformer {
    private Map<String, ConfigurationStructure> config;

    public ResolveDefaultTerms(org.kframework.kil.loader.Context context) {
        super("Resolve Default Terms", context);
        this.config = context.getConfigurationStructureMap();
    }

    @Override
    public ASTNode transform(Rule node) throws TransformerException {
        if (MetaK.isAnywhere(node)) {
            return node;
        }
        return super.transform(node);
    }

    @Override
    public ASTNode transform(Rewrite node) throws TransformerException {
        ASTNode right = node.getRight().accept(new DefaultTermsResolver(this.context));
        if (right != node.getRight()) {
            node = node.shallowCopy();
            node.setRight((Term)right, this.context);
        }
        return node;
    }

    @Override
    public ASTNode transform(Configuration node) throws TransformerException {
        return node;
    }

    @Override
    public ASTNode transform(Syntax node) throws TransformerException {
        return node;
    }

    @Override
    public ASTNode transform(Context node) throws TransformerException {
        return node;
    }

    public class DefaultTermsResolver
    extends CopyOnWriteTransformer {
        public DefaultTermsResolver(org.kframework.kil.loader.Context context) {
            super("Default Terms Resolver", context);
        }

        @Override
        public ASTNode transform(Cell node) throws TransformerException {
            Bag bag;
            Cell cell = (Cell)super.transform(node);
            if (cell.getEllipses() == Cell.Ellipses.NONE) {
                return cell;
            }
            cell = cell.shallowCopy();
            cell.setCellAttributes(new HashMap<String, String>(cell.getCellAttributes()));
            cell.setEllipses(Cell.Ellipses.NONE);
            ConfigurationStructure cellStr = (ConfigurationStructure)ResolveDefaultTerms.this.config.get(cell.getId());
            if (cellStr.sons.isEmpty()) {
                GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.COMPILER, "Cell " + node + " is a leaf in the configuration and it's not closed in the RHS.", this.getName(), node.getFilename(), node.getLocation()));
                return cell;
            }
            List<Cell> sons = MetaK.getTopCells(cell.getContents(), this.context);
            HashMap<String, ConfigurationStructure> potentialSons = new HashMap<String, ConfigurationStructure>(cellStr.sons);
            for (Cell son : sons) {
                ConfigurationStructure sonCfg = (ConfigurationStructure)potentialSons.get(son.getId());
                if (sonCfg == null || sonCfg.multiplicity != Cell.Multiplicity.ONE && sonCfg.multiplicity != Cell.Multiplicity.SOME) continue;
                potentialSons.remove(son.getId());
            }
            if (potentialSons.isEmpty()) {
                return cell;
            }
            if (cell.getContents() instanceof Bag) {
                bag = (Bag)cell.getContents().shallowCopy();
                bag.setContents(new ArrayList<Term>(bag.getContents()));
            } else {
                bag = new Bag();
                bag.getContents().add(cell.getContents());
            }
            boolean change = false;
            for (ConfigurationStructure sonCfg : potentialSons.values()) {
                if (sonCfg.multiplicity != Cell.Multiplicity.ONE && sonCfg.multiplicity != Cell.Multiplicity.SOME) continue;
                Cell son = sonCfg.cell.shallowCopy();
                son.setCellAttributes(new HashMap<String, String>());
                if (!sonCfg.sons.isEmpty()) {
                    son.setContents(new Bag());
                    son.setEllipses(Cell.Ellipses.BOTH);
                    son = (Cell)this.transform(son);
                }
                bag.getContents().add(son);
                change = true;
            }
            if (change) {
                cell.setContents(bag);
            }
            return cell;
        }
    }
}

