/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.compile.transformers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.kframework.compile.transformers.AddSymbolicK;
import org.kframework.compile.utils.MetaK;
import org.kframework.compile.utils.Substitution;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Bag;
import org.kframework.kil.BoolBuiltin;
import org.kframework.kil.Cell;
import org.kframework.kil.Configuration;
import org.kframework.kil.Definition;
import org.kframework.kil.IntBuiltin;
import org.kframework.kil.Rewrite;
import org.kframework.kil.Sentence;
import org.kframework.kil.Term;
import org.kframework.kil.TermCons;
import org.kframework.kil.Variable;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.CopyOnWriteTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;

public class ResolveFresh
extends CopyOnWriteTransformer {
    private boolean isFresh;
    private Set<Variable> vars = new HashSet<Variable>();

    public ResolveFresh(Context context) {
        super("Resolve fresh variables condition.", context);
    }

    @Override
    public ASTNode transform(Definition node) throws TransformerException {
        Bag bag;
        this.isFresh = false;
        node = (Definition)super.transform(node);
        if (!this.isFresh) {
            return node;
        }
        Configuration cfg = MetaK.getConfiguration(node, this.context);
        if (cfg.getBody() instanceof Bag) {
            bag = (Bag)cfg.getBody().shallowCopy();
        } else {
            bag = new Bag();
            bag.getContents().add(cfg.getBody());
        }
        cfg.setBody(bag);
        Cell nId = new Cell();
        nId.setLabel("freshCounter");
        nId.setEllipses(Cell.Ellipses.NONE);
        nId.setContents(IntBuiltin.ZERO);
        bag.getContents().add(nId);
        return node;
    }

    @Override
    public ASTNode transform(Sentence node) throws TransformerException {
        Bag bag;
        if (null == node.getRequires()) {
            return node;
        }
        this.vars.clear();
        ASTNode condNode = node.getRequires().accept(this);
        if (this.vars.isEmpty()) {
            return node;
        }
        node = node.shallowCopy();
        node.setRequires((Term)condNode);
        Variable freshVar = Variable.getFreshVar("Int");
        ASTNode bodyNode = node.getBody().accept(this.freshSubstitution(this.vars, freshVar));
        assert (bodyNode instanceof Term);
        if (bodyNode instanceof Bag) {
            bag = (Bag)bodyNode;
        } else {
            bag = new Bag();
            bag.getContents().add((Term)bodyNode);
        }
        node.setBody(bag);
        Cell fCell = new Cell();
        fCell.setLabel("freshCounter");
        fCell.setEllipses(Cell.Ellipses.NONE);
        TermCons t = new TermCons("Int", "Int1PlusSyn", this.context);
        t.getContents().add(freshVar);
        t.getContents().add(IntBuiltin.kAppOf(this.vars.size()));
        fCell.setContents(new Rewrite(freshVar, t, this.context));
        bag.getContents().add(fCell);
        return node;
    }

    @Override
    public ASTNode transform(TermCons node) throws TransformerException {
        if ("Bool1FreshSyn".equals(node.getCons())) {
            assert (1 == node.getContents().size());
            assert (node.getContents().get(0) instanceof Variable);
            Variable var = (Variable)node.getContents().get(0);
            this.vars.add(var);
            this.isFresh = true;
            return BoolBuiltin.TRUE;
        }
        return super.transform(node);
    }

    private Substitution freshSubstitution(Set<Variable> vars, Variable idxVar) {
        HashMap<Term, Term> symMap = new HashMap<Term, Term>();
        int idx = 0;
        for (Variable var : vars) {
            TermCons idxTerm = new TermCons("Int", "Int1PlusSyn", this.context);
            List<Term> subterms = idxTerm.getContents();
            subterms.add(idxVar);
            subterms.add(IntBuiltin.kAppOf(idx));
            ++idx;
            String sort = var.getSort();
            Term symTerm = new AddSymbolicK(this.context).makeSymbolicTerm(sort, idxTerm);
            symMap.put(var, symTerm);
        }
        return new Substitution(symMap, this.context);
    }
}

