/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.compile.transformers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.kframework.compile.transformers.AddSymbolicK;
import org.kframework.compile.utils.Substitution;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Sentence;
import org.kframework.kil.Term;
import org.kframework.kil.Variable;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.CopyOnWriteTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;

public class ResolveFreshVarMOS
extends CopyOnWriteTransformer {
    private Set<Variable> vars = new HashSet<Variable>();

    public ResolveFreshVarMOS(Context context) {
        super("Resolve fresh variables (MOS version).", context);
    }

    @Override
    public ASTNode transform(Sentence node) throws TransformerException {
        this.vars.clear();
        super.transform(node);
        if (this.vars.isEmpty()) {
            return node;
        }
        ASTNode bodyNode = node.accept(this.freshSubstitution(this.vars));
        assert (bodyNode instanceof Sentence);
        return bodyNode;
    }

    @Override
    public ASTNode transform(Variable node) throws TransformerException {
        if (node.isFresh()) {
            this.vars.add(node);
            return node;
        }
        return super.transform(node);
    }

    private Substitution freshSubstitution(Set<Variable> vars) {
        HashMap<Term, Term> symMap = new HashMap<Term, Term>();
        int idx = 0;
        for (Variable var : vars) {
            Term symTerm = new AddSymbolicK(this.context).freshSymSortN(var.getSort(), idx);
            ++idx;
            symMap.put(var, symTerm);
        }
        return new Substitution(symMap, this.context);
    }
}

