/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.compile.transformers;

import org.kframework.kil.ASTNode;
import org.kframework.kil.Configuration;
import org.kframework.kil.Context;
import org.kframework.kil.KApp;
import org.kframework.kil.KLabelConstant;
import org.kframework.kil.Production;
import org.kframework.kil.Rewrite;
import org.kframework.kil.Rule;
import org.kframework.kil.Syntax;
import org.kframework.kil.Term;
import org.kframework.kil.TermCons;
import org.kframework.kil.visitors.CopyOnWriteTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.utils.errorsystem.KException;
import org.kframework.utils.general.GlobalSettings;

public class ResolveFunctions
extends CopyOnWriteTransformer {
    public ResolveFunctions(org.kframework.kil.loader.Context context) {
        super("Resolve Functions", context);
    }

    @Override
    public ASTNode transform(Rule node) throws TransformerException {
        Term l;
        Production prod;
        Term body = node.getBody();
        if (body instanceof Rewrite) {
            body = ((Rewrite)body).getLeft();
        }
        if (body instanceof TermCons && ((prod = (Production)this.context.conses.get(((TermCons)body).getCons())).containsAttribute("function") || prod.containsAttribute("predicate"))) {
            node = this.addFunction(node);
        }
        if (body instanceof KApp && (l = ((KApp)body).getLabel()) instanceof KLabelConstant && ((KLabelConstant)l).isPredicate()) {
            node = this.addFunction(node);
        }
        return node;
    }

    private Rule addFunction(Rule node) {
        node = node.shallowCopy();
        node.setAttributes(node.getAttributes().shallowCopy());
        if (node.containsAttribute("heat")) {
            GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.COMPILER, "Top symbol tagged as function but evaluation strategies are not supported for functions.", this.getName(), node.getFilename(), node.getLocation()));
        }
        node.putAttribute("function", "");
        return node;
    }

    @Override
    public ASTNode transform(Syntax node) throws TransformerException {
        return node;
    }

    @Override
    public ASTNode transform(Context node) throws TransformerException {
        return node;
    }

    @Override
    public ASTNode transform(Configuration node) throws TransformerException {
        return node;
    }
}

