/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.compile.transformers;

import java.util.ArrayList;
import java.util.List;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Attribute;
import org.kframework.kil.BoolBuiltin;
import org.kframework.kil.Configuration;
import org.kframework.kil.Context;
import org.kframework.kil.KApp;
import org.kframework.kil.KLabelConstant;
import org.kframework.kil.Module;
import org.kframework.kil.ModuleItem;
import org.kframework.kil.Production;
import org.kframework.kil.Rewrite;
import org.kframework.kil.Rule;
import org.kframework.kil.Terminal;
import org.kframework.kil.Variable;
import org.kframework.kil.visitors.CopyOnWriteTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;

public class ResolveHybrid
extends CopyOnWriteTransformer {
    private List<ModuleItem> hybrids = new ArrayList<ModuleItem>();

    public ResolveHybrid(org.kframework.kil.loader.Context context) {
        super("Resolve Hybrid", context);
    }

    @Override
    public ASTNode transform(Module node) throws TransformerException {
        this.hybrids.clear();
        super.transform(node);
        if (this.hybrids.isEmpty()) {
            return node;
        }
        node = node.shallowCopy();
        this.hybrids.addAll(node.getItems());
        node.setItems(this.hybrids);
        return node;
    }

    @Override
    public ASTNode transform(Production node) throws TransformerException {
        if (!node.containsAttribute("hybrid")) {
            return node;
        }
        Rule rule = new Rule();
        rule.setBody(new Rewrite(KApp.of(KLabelConstant.KRESULT_PREDICATE, new KApp(KLabelConstant.of(((Terminal)node.getItems().get(0)).getTerminal(), this.context), new Variable("Ks", "KList"))), BoolBuiltin.TRUE, this.context));
        rule.setRequires(new KApp(KLabelConstant.KRESULT_PREDICATE, new Variable("Ks", "KList")));
        rule.addAttribute(Attribute.PREDICATE);
        this.hybrids.add(rule);
        return node;
    }

    @Override
    public ASTNode transform(Configuration node) throws TransformerException {
        return node;
    }

    @Override
    public ASTNode transform(Context node) throws TransformerException {
        return node;
    }

    @Override
    public ASTNode transform(Rule node) throws TransformerException {
        return node;
    }
}

