/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.compile.transformers;

import java.util.ArrayList;
import java.util.Iterator;
import org.kframework.kil.ASTNode;
import org.kframework.kil.KList;
import org.kframework.kil.Production;
import org.kframework.kil.ProductionItem;
import org.kframework.kil.Sort;
import org.kframework.kil.Syntax;
import org.kframework.kil.Term;
import org.kframework.kil.TermCons;
import org.kframework.kil.Terminal;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.CopyOnWriteTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.utils.errorsystem.KException;
import org.kframework.utils.general.GlobalSettings;

public class ResolveListOfK
extends CopyOnWriteTransformer {
    public ResolveListOfK(Context context) {
        super("Resolve KList", context);
    }

    @Override
    public ASTNode transform(Syntax node) throws TransformerException {
        return node;
    }

    @Override
    public ASTNode transform(TermCons node) throws TransformerException {
        boolean change = false;
        ArrayList<Term> terms = new ArrayList<Term>();
        Production prod = (Production)this.context.conses.get(node.getCons());
        Iterator<Term> termIt = node.getContents().iterator();
        for (ProductionItem pitem : prod.getItems()) {
            if (pitem instanceof Terminal) continue;
            Term t = termIt.next();
            ASTNode resultAST = t.accept(this);
            if (resultAST != t) {
                change = true;
            }
            if (resultAST == null) continue;
            if (!(resultAST instanceof Term)) {
                GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.INTERNAL, "Expecting Term, but got " + resultAST.getClass() + ".", this.getName(), t.getFilename(), t.getLocation()));
            }
            Term result = (Term)resultAST;
            if (pitem instanceof Sort && ((Sort)pitem).getName().equals("KList") && !t.getSort().equals("KList")) {
                KList list = new KList();
                list.getContents().add(result);
                result = list;
                change = true;
            }
            terms.add(result);
        }
        if (change) {
            node = node.shallowCopy();
            node.setContents(terms);
        }
        return this.transform((Term)node);
    }
}

