/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.compile.transformers;

import java.util.ArrayList;
import java.util.HashMap;
import org.kframework.compile.utils.MetaK;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Cell;
import org.kframework.kil.Collection;
import org.kframework.kil.Configuration;
import org.kframework.kil.Context;
import org.kframework.kil.DataStructureSort;
import org.kframework.kil.KApp;
import org.kframework.kil.KLabelConstant;
import org.kframework.kil.KSort;
import org.kframework.kil.Syntax;
import org.kframework.kil.Term;
import org.kframework.kil.Variable;
import org.kframework.kil.visitors.CopyOnWriteTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.utils.errorsystem.KException;
import org.kframework.utils.general.GlobalSettings;

public class ResolveOpenCells
extends CopyOnWriteTransformer {
    public ResolveOpenCells(org.kframework.kil.loader.Context context) {
        super("Resolve Open Cells", context);
    }

    @Override
    public ASTNode transform(Cell node) throws TransformerException {
        Collection col;
        Cell.Ellipses ellipses = (node = (Cell)super.transform(node)).getEllipses();
        if (ellipses == Cell.Ellipses.NONE) {
            return node;
        }
        node = node.shallowCopy();
        node.setCellAttributes(new HashMap<String, String>(node.getCellAttributes()));
        node.setEllipses(Cell.Ellipses.NONE);
        DataStructureSort dataStructureSort = this.context.dataStructureSortOf(this.context.cellSorts.get(node.getLabel()));
        if (dataStructureSort != null) {
            if (ellipses == Cell.Ellipses.BOTH && !dataStructureSort.type().equals("List")) {
                ellipses = Cell.Ellipses.RIGHT;
            }
            Term content = node.getContents();
            if (ellipses == Cell.Ellipses.BOTH || ellipses == Cell.Ellipses.LEFT) {
                content = KApp.of(KLabelConstant.of(dataStructureSort.constructorLabel()), Variable.getFreshVar(dataStructureSort.name()), content);
            }
            if (ellipses == Cell.Ellipses.BOTH || ellipses == Cell.Ellipses.RIGHT) {
                content = KApp.of(KLabelConstant.of(dataStructureSort.constructorLabel()), content, Variable.getFreshVar(dataStructureSort.name()));
            }
            node.setContents(content);
            return node;
        }
        KSort kind = KSort.getKSort(node.getContents().getSort()).mainSort();
        if (node.getContents() instanceof Collection) {
            col = (Collection)node.getContents().shallowCopy();
            col.setContents(new ArrayList<Term>(col.getContents()));
        } else {
            col = MetaK.createCollection(node.getContents(), kind);
            if (col == null) {
                GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.COMPILER, "Expecting a collection item here but got " + node.getContents() + " which is of sort " + (Object)((Object)kind), this.getName(), node.getFilename(), node.getLocation()));
            }
        }
        node.setContents(col);
        if (ellipses == Cell.Ellipses.BOTH && kind != KSort.K && kind != KSort.List) {
            ellipses = Cell.Ellipses.RIGHT;
        }
        if (ellipses == Cell.Ellipses.BOTH || ellipses == Cell.Ellipses.LEFT) {
            col.getContents().add(0, Variable.getFreshVar(kind.toString()));
        }
        if (ellipses == Cell.Ellipses.BOTH || ellipses == Cell.Ellipses.RIGHT) {
            col.getContents().add(Variable.getFreshVar(kind.toString()));
        }
        return node;
    }

    @Override
    public ASTNode transform(Configuration node) throws TransformerException {
        return node;
    }

    @Override
    public ASTNode transform(Syntax node) throws TransformerException {
        return node;
    }

    @Override
    public ASTNode transform(Context node) throws TransformerException {
        return node;
    }
}

