/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.compile.transformers;

import org.kframework.kil.ASTNode;
import org.kframework.kil.Configuration;
import org.kframework.kil.Context;
import org.kframework.kil.Rewrite;
import org.kframework.kil.Rule;
import org.kframework.kil.Syntax;
import org.kframework.kil.Term;
import org.kframework.kil.visitors.CopyOnWriteTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;

public class ResolveRewrite
extends CopyOnWriteTransformer {
    public ResolveRewrite(org.kframework.kil.loader.Context context) {
        super("Pushing local rewrites to top", context);
    }

    @Override
    public ASTNode transform(Rule node) throws TransformerException {
        Term body = node.getBody();
        if (body instanceof Rewrite) {
            return node;
        }
        node = node.shallowCopy();
        Term left = (Term)body.accept(new OneSideTransformer(LRHS.LEFT, this.context));
        Term right = (Term)body.accept(new OneSideTransformer(LRHS.RIGHT, this.context));
        Rewrite rewrite = new Rewrite(left, right, this.context);
        node.setBody(rewrite);
        return node;
    }

    @Override
    public ASTNode transform(Syntax node) throws TransformerException {
        return node;
    }

    @Override
    public ASTNode transform(Configuration node) throws TransformerException {
        return node;
    }

    @Override
    public ASTNode transform(Context node) throws TransformerException {
        return node;
    }

    public class OneSideTransformer
    extends CopyOnWriteTransformer {
        private LRHS lrhs;

        public OneSideTransformer(LRHS lrhs, org.kframework.kil.loader.Context context) {
            super("Retrieving the " + (Object)((Object)lrhs) + "side of the term", context);
            this.lrhs = lrhs;
        }

        @Override
        public ASTNode transform(Rewrite node) throws TransformerException {
            switch (this.lrhs) {
                case LEFT: {
                    return node.getLeft();
                }
                case RIGHT: {
                    return node.getRight();
                }
            }
            return null;
        }
    }

    public static enum LRHS {
        LEFT,
        RIGHT;

    }
}

