/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.compile.transformers;

import java.util.ArrayList;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Cell;
import org.kframework.kil.Configuration;
import org.kframework.kil.Context;
import org.kframework.kil.KApp;
import org.kframework.kil.KLabelConstant;
import org.kframework.kil.KSequence;
import org.kframework.kil.Rewrite;
import org.kframework.kil.Rule;
import org.kframework.kil.Syntax;
import org.kframework.kil.Term;
import org.kframework.kil.visitors.CopyOnWriteTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.utils.general.GlobalSettings;

public class ResolveSupercool
extends CopyOnWriteTransformer {
    public ResolveSupercool(org.kframework.kil.loader.Context context) {
        super("Cool the <k> cell for supercool rules", context);
    }

    @Override
    public ASTNode transform(Rule node) throws TransformerException {
        for (String cool : GlobalSettings.supercool) {
            if (!node.containsAttribute(cool)) continue;
            return super.transform(node);
        }
        return node;
    }

    @Override
    public ASTNode transform(Rewrite node) throws TransformerException {
        Term right = (Term)node.getRight().accept(this);
        if (right != node.getRight()) {
            node = node.shallowCopy();
            node.setRight(right, this.context);
        }
        return node;
    }

    @Override
    public ASTNode transform(Cell node) throws TransformerException {
        if (!node.getLabel().equals("k")) {
            return super.transform(node);
        }
        if ((node = node.shallowCopy()).getContents() instanceof KSequence) {
            KSequence kseq = (KSequence)node.getContents().shallowCopy();
            node.setContents(kseq);
            ArrayList<Term> kitems = new ArrayList<Term>(kseq.getContents());
            kseq.setContents(kitems);
            kitems.set(0, KApp.of(KLabelConstant.COOL_KLABEL, (Term)kitems.get(0)));
        } else {
            KApp kApp = new KApp(KLabelConstant.COOL_KLABEL, node.getContents());
            node.setContents(kApp);
        }
        return node;
    }

    @Override
    public ASTNode transform(Configuration node) throws TransformerException {
        return node;
    }

    @Override
    public ASTNode transform(Context node) throws TransformerException {
        return node;
    }

    @Override
    public ASTNode transform(Syntax node) throws TransformerException {
        return node;
    }
}

