/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.compile.transformers;

import java.util.Set;
import org.kframework.compile.transformers.AddPredicates;
import org.kframework.compile.utils.MetaK;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Configuration;
import org.kframework.kil.KApp;
import org.kframework.kil.KLabelConstant;
import org.kframework.kil.KList;
import org.kframework.kil.Sentence;
import org.kframework.kil.Syntax;
import org.kframework.kil.Term;
import org.kframework.kil.Variable;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.CopyOnWriteTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;

public class ResolveSyntaxPredicates
extends CopyOnWriteTransformer {
    public ResolveSyntaxPredicates(Context context) {
        super("Resolve syntax predicates", context);
    }

    @Override
    public ASTNode transform(Configuration node) throws TransformerException {
        return node;
    }

    @Override
    public ASTNode transform(Syntax node) throws TransformerException {
        return node;
    }

    @Override
    public ASTNode transform(Sentence node) throws TransformerException {
        boolean change = false;
        Set<Variable> vars = node.getBody().variables();
        KList ands = new KList();
        Term condition = node.getRequires();
        if (null != condition) {
            ands.getContents().add(condition);
        }
        for (Variable var : vars) {
            if (var.isSyntactic() || MetaK.isKSort(var.getSort())) continue;
            change = true;
            ands.getContents().add(this.getPredicateTerm(var));
        }
        if (!change) {
            return node;
        }
        condition = ands.getContents().size() > 1 ? new KApp(KLabelConstant.ANDBOOL_KLABEL, ands) : ands.getContents().get(0);
        node = node.shallowCopy();
        node.setRequires(condition);
        return node;
    }

    private Term getPredicateTerm(Variable var) {
        return KApp.of(KLabelConstant.of(AddPredicates.predicate(var.getSort()), this.context), var);
    }
}

