/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.compile.transformers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.kframework.compile.utils.MetaK;
import org.kframework.compile.utils.SyntaxByTag;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Attribute;
import org.kframework.kil.Attributes;
import org.kframework.kil.Context;
import org.kframework.kil.Hole;
import org.kframework.kil.KApp;
import org.kframework.kil.KLabelConstant;
import org.kframework.kil.KList;
import org.kframework.kil.Module;
import org.kframework.kil.ModuleItem;
import org.kframework.kil.Production;
import org.kframework.kil.Rewrite;
import org.kframework.kil.Sort;
import org.kframework.kil.Term;
import org.kframework.kil.TermCons;
import org.kframework.kil.Terminal;
import org.kframework.kil.Variable;
import org.kframework.kil.visitors.CopyOnWriteTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.parser.basic.Basic;
import org.kframework.parser.basic.ParseException;
import org.kframework.utils.errorsystem.KException;
import org.kframework.utils.general.GlobalSettings;

public class StrictnessToContexts
extends CopyOnWriteTransformer {
    public static final String ALL = "all";
    public static final String OTHER = "other";
    public static final String DEFAULT_STRICTNESS_CELL = "k";
    public static final String STRICT = "strict";
    public static final String SEQSTRICT = "seqstrict";
    public static final String CONTEXT = "context";
    private List<ModuleItem> items = new ArrayList<ModuleItem>();

    public StrictnessToContexts(org.kframework.kil.loader.Context context) {
        super("Strict Ops To Context", context);
    }

    @Override
    public ASTNode transform(Module node) throws TransformerException {
        Set<Production> prods = SyntaxByTag.get(node, STRICT, true, this.context);
        prods.addAll(SyntaxByTag.get(node, SEQSTRICT, true, this.context));
        if (prods.isEmpty()) {
            return node;
        }
        this.items = new ArrayList<ModuleItem>(node.getItems());
        node = node.shallowCopy();
        node.setItems(this.items);
        for (Production prod : prods) {
            String strictCell;
            Attribute allStrictAttr;
            String strictType;
            assert (prod.containsAttribute(STRICT, true) && !prod.containsAttribute(SEQSTRICT, true) || !prod.containsAttribute(STRICT, true) && prod.containsAttribute(SEQSTRICT, true));
            Boolean isSeq = prod.containsAttribute(SEQSTRICT, true);
            if (!MetaK.isComputationSort(prod.getSort()) || prod.getSort().equals("KLabel")) {
                GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.COMPILER, "only productions of sort K, sort KLabel or of syntactic sorts can have strictness attributes", this.getName(), prod.getFilename(), prod.getLocation()));
                continue;
            }
            if (prod.isSubsort()) {
                if (prod.getAttribute("klabel") == null) {
                    GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.COMPILER, "Production is a subsort and cannot be strict.", this.getName(), prod.getFilename(), prod.getLocation()));
                    continue;
                }
                Attributes attributes = prod.getAttributes();
                prod = new Production(new Sort("KLabel"), Collections.singletonList(new Terminal(prod.getKLabel())));
                prod.setAttributes(attributes);
                this.kLabelStrictness(prod, isSeq);
                continue;
            }
            if (prod.isConstant()) {
                GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.COMPILER, "Production is a constant and cannot be strict.", this.getName(), prod.getFilename(), prod.getLocation()));
                continue;
            }
            if (!isSeq.booleanValue()) {
                strictType = STRICT;
                allStrictAttr = prod.getAttributes().getAttributeByKey(strictType, true);
            } else {
                strictType = SEQSTRICT;
                allStrictAttr = prod.getAttributes().getAttributeByKey(strictType, true);
            }
            String attribute = allStrictAttr.getValue();
            String allStrictAttrKey = allStrictAttr.getKey();
            if (allStrictAttrKey.length() == strictType.length()) {
                strictCell = DEFAULT_STRICTNESS_CELL;
            } else {
                if (allStrictAttrKey.charAt(strictType.length()) != '<' || allStrictAttrKey.charAt(allStrictAttrKey.length() - 1) != '>') {
                    GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.COMPILER, "Expecting attribute " + strictType + "<cell>, but got " + allStrictAttrKey, this.getName(), prod.getFilename(), prod.getLocation()));
                }
                strictCell = allStrictAttrKey.substring(1 + strictType.length(), allStrictAttrKey.length() - 1);
            }
            Attribute strictCellAttr = new Attribute("cell", strictCell);
            Attributes strictAttrs = null;
            if (attribute.isEmpty()) {
                attribute = ALL;
            }
            if (prod.getSort().equals("KLabel")) {
                assert (attribute.equals(ALL) && strictCell.equals(DEFAULT_STRICTNESS_CELL)) : "Customized strictness for K labels not currently implemented";
                this.kLabelStrictness(prod, isSeq);
                continue;
            }
            try {
                strictAttrs = Basic.parseAttributes(attribute, prod.getFilename());
            }
            catch (ParseException e) {
                GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.COMPILER, "Strictness attributes " + attribute + " could not be parsed." + "Parse error: " + e.getMessage(), this.getName(), prod.getFilename(), prod.getLocation()));
            }
            for (Attribute strictAttr : strictAttrs.getContents()) {
                Attributes strictAttrAttrs = null;
                String strictAttrKey = strictAttr.getKey();
                String strictAttrValue = strictAttr.getValue();
                if (strictAttrValue.isEmpty()) {
                    strictAttrAttrs = new Attributes();
                } else {
                    try {
                        strictAttrAttrs = Basic.parseAttributes(strictAttrValue, prod.getFilename());
                    }
                    catch (ParseException e) {
                        GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.COMPILER, "Strictness attributes could not be parsed for " + strictAttrValue + "." + "Parse error: " + e.getMessage(), this.getName(), prod.getFilename(), prod.getLocation()));
                    }
                }
                strictAttr.setAttributes(strictAttrAttrs);
            }
            ArrayList<Attribute> newStrictAttrs = new ArrayList<Attribute>();
            HashMap<Integer, Integer> strictPositions = new HashMap<Integer, Integer>();
            for (Attribute strictAttr : strictAttrs.getContents()) {
                Attribute newStrictAttr2;
                boolean other = false;
                String strictAttrKey = strictAttr.getKey();
                String strictAttrValue = strictAttr.getValue();
                if (strictAttrKey.equals(ALL)) {
                    for (Attribute newStrictAttr2 : newStrictAttrs) {
                        newStrictAttr2.getAttributes().setAll(strictAttr.getAttributes());
                    }
                    other = true;
                } else if (strictAttrKey.equals(OTHER)) {
                    other = true;
                } else {
                    int i = 0;
                    try {
                        i = Integer.parseInt(strictAttrKey);
                    }
                    catch (NumberFormatException e) {
                        GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.COMPILER, "Expecting all, other, or a number, but found " + strictAttrKey + " as a" + " strict position in " + strictAttrValue, this.getName(), prod.getFilename(), prod.getLocation()));
                    }
                    if (i <= 0 || i > prod.getArity()) {
                        GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.COMPILER, "Expecting a number between 1 and " + prod.getArity() + ", but found " + strictAttrKey + " as a" + " strict position in " + strictAttrValue, this.getName(), prod.getFilename(), prod.getLocation()));
                    }
                    if (!strictPositions.containsKey(i)) {
                        strictPositions.put(i, newStrictAttrs.size());
                        newStrictAttr2 = strictAttr.shallowCopy();
                        newStrictAttr2.setAttributes(new Attributes());
                        newStrictAttr2.getAttributes().set(strictCellAttr);
                        newStrictAttr2.getAttributes().setAll(strictAttr.getAttributes());
                        newStrictAttrs.add(strictAttr);
                    } else {
                        ((Attribute)newStrictAttrs.get((Integer)strictPositions.get(i))).getAttributes().setAll(strictAttr.getAttributes());
                    }
                }
                if (!other) continue;
                for (int i = 1; i <= prod.getArity(); ++i) {
                    if (strictPositions.containsKey(i)) continue;
                    strictPositions.put(i, newStrictAttrs.size());
                    newStrictAttr2 = new Attribute(Integer.toString(i), strictAttrValue);
                    newStrictAttr2.setAttributes(new Attributes());
                    newStrictAttr2.getAttributes().set(strictCellAttr);
                    newStrictAttr2.getAttributes().setAll(strictAttr.getAttributes());
                    newStrictAttrs.add(newStrictAttr2);
                }
            }
            for (int i = 0; i < newStrictAttrs.size(); ++i) {
                Attribute newStrictAttr = (Attribute)newStrictAttrs.get(i);
                TermCons termCons = (TermCons)MetaK.getTerm(prod, this.context);
                for (int j = 0; j < prod.getArity(); ++j) {
                    if (GlobalSettings.javaBackend) {
                        if (GlobalSettings.testgen) continue;
                        termCons.getContents().get(j).setSort("KItem");
                        continue;
                    }
                    termCons.getContents().get(j).setSort("K");
                }
                termCons.getContents().set(-1 + Integer.parseInt(newStrictAttr.getKey()), this.getHoleTerm(newStrictAttr.getAttributes(), prod));
                KApp sideCond = null;
                if (isSeq.booleanValue()) {
                    for (int j = 0; j < i; ++j) {
                        Term arg = termCons.getContents().get(-1 + Integer.parseInt(((Attribute)newStrictAttrs.get(j)).getKey()));
                        if (GlobalSettings.testgen) {
                            KApp kResultPred = KApp.of(KLabelConstant.KRESULT_PREDICATE, arg);
                            sideCond = sideCond == null ? kResultPred : KApp.of(KLabelConstant.BOOL_ANDBOOL_KLABEL, sideCond, kResultPred);
                            continue;
                        }
                        arg.setSort("KResult");
                    }
                }
                Context ctx = new Context();
                ctx.setBody(termCons);
                ctx.setAttributes(new Attributes());
                ctx.getAttributes().setAll(prod.getAttributes());
                String strictContext = newStrictAttr.getAttribute(CONTEXT);
                if (strictContext != null) {
                    Set<Production> productions = this.getStrictContextProductions(strictContext, prod);
                    assert (productions.size() == 1) : "Expecting only one production for context " + strictContext + " but found " + productions.size() + ": " + productions;
                    Production strictContextProd = productions.iterator().next();
                    String strictContextProdAttribute = strictContextProd.getAttribute(CONTEXT);
                    if (!strictContextProdAttribute.isEmpty()) {
                        try {
                            Attributes strictContextAttrs = Basic.parseAttributes(strictContextProdAttribute, strictContextProd.getFilename());
                            ctx.getAttributes().setAll(strictContextAttrs);
                        }
                        catch (ParseException e) {
                            GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.COMPILER, "Context attributes could not be parsed for " + strictContextProdAttribute + ".\n" + "Parse error: " + e.getMessage(), this.getName(), strictContextProd.getFilename(), strictContextProd.getLocation()));
                        }
                    }
                }
                ctx.getAttributes().setAll(newStrictAttr.getAttributes());
                if (sideCond != null) {
                    ctx.setRequires(sideCond);
                }
                this.items.add(ctx);
            }
        }
        return node;
    }

    private Term getHoleTerm(Attributes strictnessAttributes, Production prod) {
        Term hole;
        String strictType = null;
        if (strictnessAttributes != null) {
            strictType = strictnessAttributes.get(CONTEXT);
        }
        if (null == strictType) {
            hole = Hole.KITEM_HOLE;
        } else {
            this.getStrictContextProductions(strictType, prod);
            hole = new Rewrite(Hole.KITEM_HOLE, KApp.of(KLabelConstant.of(strictType), Hole.KITEM_HOLE), this.context);
        }
        return hole;
    }

    private Set<Production> getStrictContextProductions(String strictType, Production prod) {
        Set<Production> productions = this.context.productions.get(strictType);
        if (productions == null) {
            GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.COMPILER, "Strictness context label " + strictType + " does not correspond to any production.", this.getName(), prod.getFilename(), prod.getLocation()));
        }
        return productions;
    }

    private void kLabelStrictness(Production prod, boolean isSeq) {
        ArrayList<Term> contents = new ArrayList<Term>(3);
        Variable variable = Variable.getFreshVar("KList");
        contents.add(variable);
        contents.add(this.getHoleTerm(null, prod));
        contents.add(Variable.getFreshVar("KList"));
        KApp kapp = new KApp(MetaK.getTerm(prod, this.context), new KList(contents));
        Context ctx = new Context();
        ctx.setBody(kapp);
        ctx.setAttributes(prod.getAttributes());
        if (isSeq) {
            KApp condApp = KApp.of(KLabelConstant.KRESULT_PREDICATE, variable);
            ctx.setRequires(condApp);
            ctx.getAttributes().remove(SEQSTRICT);
        } else {
            ctx.getAttributes().remove(STRICT);
        }
        this.items.add(ctx);
    }
}

