/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.compile.utils;

import java.util.Collections;
import org.kframework.kil.ASTNode;
import org.kframework.kil.DataStructureBuiltin;
import org.kframework.kil.DataStructureSort;
import org.kframework.kil.KApp;
import org.kframework.kil.KLabelConstant;
import org.kframework.kil.KList;
import org.kframework.kil.MapUpdate;
import org.kframework.kil.Production;
import org.kframework.kil.Rewrite;
import org.kframework.kil.Rule;
import org.kframework.kil.Term;
import org.kframework.kil.Variable;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.CopyOnWriteTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.utils.errorsystem.KException;
import org.kframework.utils.general.GlobalSettings;

public class CompileDataStructures
extends CopyOnWriteTransformer {
    private Status status;
    private String location;
    private String filename;

    public CompileDataStructures(Context context) {
        super("Compile collections to internal K representation", context);
    }

    @Override
    public ASTNode transform(Rule node) throws TransformerException {
        Term requires;
        this.location = node.getLocation();
        this.filename = node.getFilename();
        assert (node.getBody() instanceof Rewrite) : "expected rewrite at the top of rule\n" + node + "\n" + "CompileDataStructures pass should be applied after ResolveRewrite pass";
        Rewrite rewrite = (Rewrite)node.getBody();
        this.status = Status.LHS;
        Term lhs = (Term)rewrite.getLeft().accept(this);
        this.status = Status.RHS;
        Term rhs = (Term)rewrite.getRight().accept(this);
        if (node.getRequires() != null) {
            this.status = Status.CONDITION;
            requires = (Term)node.getRequires().accept(this);
        } else {
            requires = null;
        }
        if (lhs == rewrite.getLeft() && rhs == rewrite.getRight() && requires == node.getRequires()) {
            return node;
        }
        node = node.shallowCopy();
        rewrite = rewrite.shallowCopy();
        node.setBody(rewrite);
        rewrite.setLeft(lhs, this.context);
        rewrite.setRight(rhs, this.context);
        node.setRequires(requires);
        return node;
    }

    @Override
    public ASTNode transform(Rewrite node) throws TransformerException {
        assert (false) : "CompileDataStructures pass should be applied after ResolveRewrite pass";
        return node;
    }

    @Override
    public ASTNode transform(KApp node) throws TransformerException {
        if (!(node.getLabel() instanceof KLabelConstant)) {
            return super.transform(node);
        }
        KLabelConstant kLabelConstant = (KLabelConstant)node.getLabel();
        if (!(node.getChild() instanceof KList)) {
            return super.transform(node);
        }
        KList kList = (KList)node.getChild();
        if (this.context.productionsOf(kLabelConstant.getLabel()).size() != 1) {
            return super.transform(node);
        }
        Production production = this.context.productionsOf(kLabelConstant.getLabel()).iterator().next();
        DataStructureSort sort = this.context.dataStructureSortOf(production.getSort());
        if (sort == null) {
            return super.transform(node);
        }
        Term[] arguments = new Term[kList.getContents().size()];
        for (int i = 0; i < kList.getContents().size(); ++i) {
            arguments[i] = (Term)kList.getContents().get(i).accept(this);
        }
        if (sort.constructorLabel().equals(kLabelConstant.getLabel())) {
            DataStructureBuiltin dataStructure = DataStructureBuiltin.of(sort, arguments);
            if (this.status == Status.LHS && !dataStructure.isLHSView()) {
                GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, "unexpected left-hand side data structure format; expected elements and at most one variable\n" + node, this.getName(), this.filename, this.location));
                return null;
            }
            return dataStructure;
        }
        if (sort.elementLabel().equals(kLabelConstant.getLabel())) {
            return DataStructureBuiltin.element(sort, arguments);
        }
        if (sort.unitLabel().equals(kLabelConstant.getLabel())) {
            if (kList.isEmpty()) {
                return DataStructureBuiltin.empty(sort);
            }
            GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, "unexpected non-empty KList applied to constant KLabel " + kLabelConstant, this.getName(), this.filename, this.location));
            return super.transform(node);
        }
        if (sort.type().equals("Map")) {
            try {
                if (sort.operatorLabels().get("update").equals(kLabelConstant.getLabel())) {
                    return new MapUpdate((Variable)kList.getContents().get(0), Collections.emptyMap(), Collections.singletonMap(kList.getContents().get(1), kList.getContents().get(2)));
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return super.transform(node);
        }
        return super.transform(node);
    }

    private static enum Status {
        LHS,
        RHS,
        CONDITION;

    }
}

