/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.compile.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Configuration;
import org.kframework.kil.KApp;
import org.kframework.kil.KInjectedLabel;
import org.kframework.kil.KLabelConstant;
import org.kframework.kil.KList;
import org.kframework.kil.ListItem;
import org.kframework.kil.Map;
import org.kframework.kil.MapItem;
import org.kframework.kil.Module;
import org.kframework.kil.Production;
import org.kframework.kil.Rule;
import org.kframework.kil.SetItem;
import org.kframework.kil.Term;
import org.kframework.kil.TermCons;
import org.kframework.kil.Variable;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.CopyOnWriteTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;

public class CompileToBuiltins
extends CopyOnWriteTransformer {
    private static java.util.Map<String, String> builtinCollectionOps = new HashMap<String, String>();
    private static java.util.Map<String, String> builtinCollectionLabels;
    private static Set<String> undeclaredLabels;

    public CompileToBuiltins(Context context) {
        super("Compile data structure into builtin data structures", context);
    }

    @Override
    public ASTNode transform(Configuration node) throws TransformerException {
        ASTNode result = super.transform(node);
        return result;
    }

    @Override
    public ASTNode transform(KApp node) throws TransformerException {
        KLabelConstant label;
        String newLabel;
        Term term;
        TermCons cons;
        String label2;
        if (node.getLabel() instanceof TermCons && (label2 = this.getLabelOf(cons = (TermCons)node.getLabel())).equals("Set2KLabel_")) {
            return cons.getContents().get(0).accept(this);
        }
        if (node.getLabel() instanceof KInjectedLabel && (this.isCollectionItem((term = ((KInjectedLabel)node.getLabel()).getTerm()).getSort()) || this.isCollection(term.getSort()))) {
            return term.accept(this);
        }
        if ((node = (KApp)super.transform(node)).getLabel() instanceof KLabelConstant && (newLabel = builtinCollectionLabels.get((label = (KLabelConstant)node.getLabel()).getLabel())) != null) {
            node = new KApp(KLabelConstant.of(newLabel), node.getChild());
        }
        return node;
    }

    @Override
    public ASTNode transform(org.kframework.kil.List node) throws TransformerException {
        if (node.getContents().isEmpty()) {
            return new KApp(KLabelConstant.of("'.MyList"), KList.EMPTY);
        }
        List<Term> contents = this.transformTerms(node.getContents());
        return new KApp(KLabelConstant.of("'_List_"), new KList(contents));
    }

    @Override
    public ASTNode transform(org.kframework.kil.Set node) throws TransformerException {
        if (node.getContents().isEmpty()) {
            return new KApp(KLabelConstant.of("'.MySet"), KList.EMPTY);
        }
        List<Term> contents = this.transformTerms(node.getContents());
        return new KApp(KLabelConstant.of("'_Set_"), new KList(contents));
    }

    @Override
    public ASTNode transform(Rule node) throws TransformerException {
        if (node.getFilename().contains("include")) {
            return node;
        }
        ASTNode transform = super.transform(node);
        return transform;
    }

    @Override
    public ASTNode transform(Map node) throws TransformerException {
        if (node.getContents().isEmpty()) {
            return new KApp(KLabelConstant.of("'.MyMap"), KList.EMPTY);
        }
        List<Term> contents = this.transformTerms(node.getContents());
        return new KApp(KLabelConstant.of("'_Map_"), new KList(contents));
    }

    @Override
    public ASTNode transform(TermCons node) throws TransformerException {
        String label = this.getLabelOf(node);
        if (!this.isCollection(node.getSort()) && !this.isCollectionItem(node.getSort())) {
            return super.transform(node);
        }
        if (label.equals("_[_/_]")) {
            List<Term> terms = node.getContents();
            List<Term> contents = this.transformTerms(terms);
            Term map = contents.get(0);
            Term keyList = contents.get(2);
            Term valueList = contents.get(1);
            assert (keyList instanceof KList) : "Expecting a KList here";
            Term key = ((KList)keyList).getContents().get(0);
            assert (valueList instanceof KList) : "Expecting a KList here";
            Term value = ((KList)valueList).getContents().get(0);
            return KApp.of(KLabelConstant.of("'_[_<-_]"), map, key, value);
        }
        return this.transformBuiltinOp(node);
    }

    private String getLabelOf(TermCons node) {
        return ((Production)this.context.conses.get(node.getCons())).getLabel();
    }

    private List<Term> transformTerms(List<Term> terms) throws TransformerException {
        ArrayList<Term> contents = new ArrayList<Term>();
        for (Term t : terms) {
            Term tnew = (Term)t.accept(this);
            if (tnew == null) continue;
            contents.add(tnew);
        }
        return contents;
    }

    private ASTNode transformBuiltinOp(TermCons node) throws TransformerException {
        String label = this.getLabelOf(node);
        String newLabel = null;
        if (builtinCollectionOps.containsKey(label)) {
            newLabel = builtinCollectionOps.get(label);
        } else {
            newLabel = "'#" + node.getSort() + label;
            undeclaredLabels.add(newLabel);
        }
        List<Term> contents = this.transformTerms(node.getContents());
        return new KApp(KLabelConstant.of(newLabel), new KList(contents));
    }

    @Override
    public ASTNode transform(MapItem node) throws TransformerException {
        Term key = (Term)node.getKey().accept(this);
        Term value = (Term)node.getValue().accept(this);
        ArrayList<Term> contents = new ArrayList<Term>();
        contents.add(key);
        contents.add(value);
        return new KApp(KLabelConstant.of("'_|->_"), new KList(contents));
    }

    @Override
    public ASTNode transform(ListItem node) throws TransformerException {
        ArrayList<Term> contents = new ArrayList<Term>();
        contents.add((Term)node.getItem().accept(this));
        return new KApp(KLabelConstant.of("'MyListItem"), new KList(contents));
    }

    @Override
    public ASTNode transform(SetItem node) throws TransformerException {
        ArrayList<Term> contents = new ArrayList<Term>();
        contents.add((Term)node.getItem().accept(this));
        return new KApp(KLabelConstant.of("'MySetItem"), new KList(contents));
    }

    private boolean isCollection(String sort) {
        return sort.equals("Map") || sort.equals("List") || sort.equals("Set");
    }

    private boolean isCollectionItem(String sort) {
        return sort.equals("MapItem") || sort.equals("ListItem") || sort.equals("SetItem");
    }

    @Override
    public ASTNode transform(Variable node) throws TransformerException {
        if (this.isCollectionItem(node.getSort())) {
            if (node.isGenerated()) {
                ArrayList<Term> contents = new ArrayList<Term>();
                contents.add(new Variable(node.getName(), "KItem"));
                return new KApp(KLabelConstant.of("'My" + node.getSort()), new KList(contents));
            }
            node = node.shallowCopy();
            node.setSort("My" + node.getSort());
            node.setExpectedSort(node.getSort());
        } else if (this.isCollection(node.getSort())) {
            node = node.shallowCopy();
            node.setSort("My" + node.getSort());
            node.setExpectedSort(node.getSort());
        }
        return super.transform(node);
    }

    @Override
    public ASTNode transform(Module node) throws TransformerException {
        Module result = (Module)super.transform(node);
        for (String label : undeclaredLabels) {
            result.addConstant("KLabel", label);
        }
        return result;
    }

    static {
        builtinCollectionOps.put("_-Set_", "'_-MySet_");
        builtinCollectionOps.put("#variables(_)", "#variables(_)");
        builtinCollectionOps.put("keys_", "'keys");
        builtinCollectionLabels = new HashMap<String, String>();
        builtinCollectionLabels.put("inSet", "'_in_");
        undeclaredLabels = new HashSet<String>();
    }
}

