/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.compile.utils;

import java.util.ArrayList;
import java.util.List;
import org.kframework.compile.utils.BasicCompilerStep;
import org.kframework.compile.utils.CompilerStep;
import org.kframework.compile.utils.CompilerStepDone;
import org.kframework.compile.utils.CompilerTransformerStep;
import org.kframework.kil.ASTNode;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.Transformer;

public class CompilerSteps<T extends ASTNode>
extends BasicCompilerStep<T> {
    List<CompilerStep<T>> steps;

    public CompilerSteps(Context context) {
        super(context);
        this.steps = new ArrayList<CompilerStep<T>>();
    }

    public CompilerSteps(List<CompilerStep<T>> ts, Context context) {
        super(context);
        this.steps = new ArrayList<CompilerStep<T>>(ts);
    }

    public void add(CompilerStep<T> t) {
        this.steps.add(t);
    }

    public void add(Transformer t) {
        this.steps.add(new CompilerTransformerStep(t, this.context));
    }

    @Override
    public T compile(T def, String stepName) throws CompilerStepDone {
        for (CompilerStep<T> step : this.steps) {
            step.setSw(this.sw);
            def = step.compile(def, stepName);
            if (!step.getName().equals(stepName)) continue;
            throw new CompilerStepDone(def);
        }
        return def;
    }

    @Override
    public String getName() {
        String result = "Aggregated transformers:\n";
        for (CompilerStep<T> t : this.steps) {
            result = result + "\t" + t.getName() + "\n";
        }
        return result;
    }
}

