/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.compile.utils;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.kframework.compile.utils.ConfigurationStructure;
import org.kframework.kil.Cell;
import org.kframework.utils.errorsystem.KException;
import org.kframework.utils.general.GlobalSettings;

public class ConfigurationStructureMap
implements Map<String, ConfigurationStructure>,
Serializable {
    Map<String, ConfigurationStructure> config;

    public ConfigurationStructureMap() {
        this(new HashMap<String, ConfigurationStructure>());
    }

    public ConfigurationStructureMap(Map<String, ConfigurationStructure> config) {
        this.config = config;
    }

    @Override
    public int size() {
        return this.config.size();
    }

    @Override
    public boolean isEmpty() {
        return this.config.isEmpty();
    }

    @Override
    public boolean containsKey(Object o) {
        return this.config.containsKey(o);
    }

    @Override
    public boolean containsValue(Object o) {
        return this.config.containsValue(o);
    }

    @Override
    public ConfigurationStructure get(Object o) {
        return this.config.get(o);
    }

    public ConfigurationStructure get(Cell o) {
        ConfigurationStructure cfgStr = this.config.get(o.getId());
        if (cfgStr == null) {
            GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.INTERNAL, "Cell " + o + " not found in configuration", this.getClass().getName(), o.getFilename(), o.getLocation()));
        }
        return cfgStr;
    }

    @Override
    public ConfigurationStructure put(String s, ConfigurationStructure configurationStructure) {
        if (this.config.containsKey(s)) {
            Cell c = this.config.get((Object)s).cell;
            GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.INTERNAL, "Cell " + s + " found twice in configuration (once at " + c.getLocation() + ").", this.getClass().getName(), configurationStructure.cell.getFilename(), configurationStructure.cell.getLocation()));
        }
        return this.config.put(s, configurationStructure);
    }

    @Override
    public ConfigurationStructure remove(Object o) {
        return this.config.remove(o);
    }

    @Override
    public void putAll(Map<? extends String, ? extends ConfigurationStructure> map) {
        this.config.putAll(map);
    }

    @Override
    public void clear() {
        this.config.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.config.keySet();
    }

    @Override
    public Collection<ConfigurationStructure> values() {
        return this.config.values();
    }

    @Override
    public Set<Map.Entry<String, ConfigurationStructure>> entrySet() {
        return this.config.entrySet();
    }
}

