/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.compile.utils;

import java.util.Stack;
import org.kframework.compile.utils.ConfigurationStructure;
import org.kframework.compile.utils.ConfigurationStructureMap;
import org.kframework.kil.Cell;
import org.kframework.kil.Configuration;
import org.kframework.kil.Context;
import org.kframework.kil.Rule;
import org.kframework.kil.Syntax;
import org.kframework.kil.Term;
import org.kframework.kil.visitors.BasicVisitor;

public class ConfigurationStructureVisitor
extends BasicVisitor {
    Stack<ConfigurationStructure> ancestors = new Stack();
    private ConfigurationStructureMap config;
    private int maxLevel = 0;

    public ConfigurationStructureVisitor(org.kframework.kil.loader.Context context) {
        super(context);
        this.config = context.getConfigurationStructureMap();
        this.config.clear();
    }

    @Override
    public void visit(Configuration node) {
        Term t = node.getBody();
        Cell top = new Cell();
        top.setLabel("___CONTEXT_ABSTRACTION_TOP_CELL___");
        top.setId("___CONTEXT_ABSTRACTION_TOP_CELL___");
        top.setContents(t);
        top.accept(this);
    }

    @Override
    public void visit(Cell node) {
        ConfigurationStructure cfg = new ConfigurationStructure();
        cfg.multiplicity = node.getMultiplicity();
        cfg.id = node.getId();
        cfg.cell = node;
        if (!this.ancestors.empty()) {
            ConfigurationStructure parent = this.ancestors.peek();
            cfg.level = parent.level + 1;
            cfg.parent = parent;
            if (cfg.level > this.maxLevel) {
                this.maxLevel = cfg.level;
            }
            parent.sons.put(cfg.id, cfg);
        }
        this.ancestors.push(cfg);
        super.visit(node);
        this.ancestors.pop();
        this.config.put(cfg.id, cfg);
    }

    @Override
    public void visit(Context node) {
    }

    @Override
    public void visit(Syntax node) {
    }

    @Override
    public void visit(Rule node) {
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }
}

