/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.compile.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.kframework.compile.utils.NonLocalExit;
import org.kframework.kil.Attribute;
import org.kframework.kil.Bag;
import org.kframework.kil.BoolBuiltin;
import org.kframework.kil.Cell;
import org.kframework.kil.Collection;
import org.kframework.kil.Configuration;
import org.kframework.kil.Definition;
import org.kframework.kil.GenericToken;
import org.kframework.kil.Hole;
import org.kframework.kil.IntBuiltin;
import org.kframework.kil.KApp;
import org.kframework.kil.KLabelConstant;
import org.kframework.kil.KList;
import org.kframework.kil.KSequence;
import org.kframework.kil.KSort;
import org.kframework.kil.ListItem;
import org.kframework.kil.ListTerminator;
import org.kframework.kil.Map;
import org.kframework.kil.MapItem;
import org.kframework.kil.Production;
import org.kframework.kil.ProductionItem;
import org.kframework.kil.Rewrite;
import org.kframework.kil.Rule;
import org.kframework.kil.Set;
import org.kframework.kil.SetItem;
import org.kframework.kil.Sort;
import org.kframework.kil.StringBuiltin;
import org.kframework.kil.Syntax;
import org.kframework.kil.Term;
import org.kframework.kil.TermCons;
import org.kframework.kil.Terminal;
import org.kframework.kil.UserList;
import org.kframework.kil.Variable;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.BasicVisitor;
import org.kframework.utils.StringUtil;
import org.kframework.utils.errorsystem.KException;
import org.kframework.utils.general.GlobalSettings;

public class MetaK {
    public static final String cellSort = "CellSort";
    public static final String cellFragment = "CellFragment";
    public static java.util.Set<String> kModules = new HashSet<String>();
    public static java.util.Set<Attribute> anywheres;

    public static Term incrementCondition(Term condition, Term kresultCnd) {
        if (condition == null) {
            return kresultCnd;
        }
        return KApp.of(KLabelConstant.ANDBOOL_KLABEL, condition, kresultCnd);
    }

    public static boolean isCellSort(String bigSort) {
        return bigSort.endsWith(cellSort) || bigSort.endsWith(cellFragment);
    }

    public static boolean isCellFragment(String bigSort) {
        return bigSort.endsWith(cellFragment);
    }

    public static String cellSort(String cellName) {
        return StringUtil.makeProper(cellName) + cellSort;
    }

    public static String cellFragment(String cellName) {
        return StringUtil.makeProper(cellName) + cellFragment;
    }

    public static String cellUnit(String cellName) {
        return "." + MetaK.cellFragment(cellName);
    }

    public static boolean isKModule(String key) {
        return kModules.contains(key);
    }

    public static boolean isBuiltinModule(String key) {
        return key.startsWith("#");
    }

    public static Configuration getConfiguration(Definition node, Context context) {
        final LinkedList result = new LinkedList();
        node.accept(new BasicVisitor(context){

            @Override
            public void visit(Configuration node) {
                result.add(node);
            }

            @Override
            public void visit(org.kframework.kil.Context node) {
            }

            @Override
            public void visit(Rule node) {
            }

            @Override
            public void visit(Syntax node) {
            }
        });
        if (result.size() == 0) {
            GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.INTERNAL, "Internal compiler error --- Cannot find configuration.", node.getFilename(), node.getLocation()));
        }
        return (Configuration)result.get(0);
    }

    public static Term defaultTerm(Term v, Context context) {
        String sort = v.getSort();
        KSort ksort = KSort.getKSort(sort).mainSort();
        if (ksort.isDefaultable()) {
            return new ListTerminator(ksort.toString(), null);
        }
        GlobalSettings.kem.register(new KException(KException.ExceptionType.WARNING, KException.KExceptionGroup.COMPILER, "Don't know the default value for term " + v.toString() + ". Assuming .K", v.getFilename(), v.getLocation()));
        return KSequence.EMPTY;
    }

    public static boolean isKSort(String sort) {
        try {
            KSort.valueOf(sort);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    public static boolean isAnywhere(Rule r) {
        if (null == r.getAttributes()) {
            return false;
        }
        for (Attribute any : anywheres) {
            if (any.getValue() != r.getAttribute(any.getKey())) continue;
            return true;
        }
        return false;
    }

    public static Term kWrap(Term t, String komputationCellName) {
        return MetaK.wrap(t, komputationCellName, Cell.Ellipses.RIGHT);
    }

    public static Term wrap(Term t, String label, Cell.Ellipses ellipses) {
        Cell cell = new Cell(t.getLocation(), t.getFilename());
        cell.setLabel(label);
        cell.setEllipses(ellipses);
        cell.setContents(t);
        return cell;
    }

    public static Variable freshVar(java.util.Set<Variable> vars, String sort) {
        String prefix = "?";
        int i = 0;
        Variable v = new Variable(prefix + i, sort);
        while (vars.contains(v)) {
            v.setName(prefix + ++i);
        }
        return v;
    }

    public static int countRewrites(Term t, Context context) {
        final ArrayList<Integer> count = new ArrayList<Integer>();
        count.add(0);
        BasicVisitor countVisitor = new BasicVisitor(context){

            @Override
            public void visit(Rewrite rewrite) {
                count.set(0, (Integer)count.get(0) + 1);
                super.visit(rewrite);
            }
        };
        t.accept(countVisitor);
        return (Integer)count.get(0);
    }

    public static int countHoles(Term t, Context context) {
        final ArrayList<Integer> count = new ArrayList<Integer>();
        count.add(0);
        BasicVisitor countVisitor = new BasicVisitor(context){

            @Override
            public void visit(Hole hole) {
                count.set(0, (Integer)count.get(0) + 1);
                super.visit(hole);
            }
        };
        t.accept(countVisitor);
        return (Integer)count.get(0);
    }

    public static boolean hasCell(Term t, Context context) {
        BasicVisitor cellFinder = new BasicVisitor(context){

            @Override
            public void visit(KSequence node) {
            }

            @Override
            public void visit(org.kframework.kil.List node) {
            }

            @Override
            public void visit(ListItem node) {
            }

            @Override
            public void visit(TermCons node) {
            }

            @Override
            public void visit(Set node) {
            }

            @Override
            public void visit(SetItem node) {
            }

            @Override
            public void visit(KApp node) {
            }

            @Override
            public void visit(KList node) {
            }

            @Override
            public void visit(Map node) {
            }

            @Override
            public void visit(MapItem node) {
            }

            @Override
            public void visit(UserList node) {
            }

            @Override
            public void visit(Cell node) {
                NonLocalExit.RETURN();
            }
        };
        try {
            t.accept(cellFinder);
        }
        catch (NonLocalExit e) {
            return true;
        }
        return false;
    }

    public static Term getTerm(Production prod, Context context) {
        if (prod.isSubsort()) {
            Variable freshVar = Variable.getFreshVar(prod.getItems().get(0).toString());
            if (prod.containsAttribute("klabel")) {
                return KApp.of(KLabelConstant.of(prod.getKLabel(), context), freshVar);
            }
            return freshVar;
        }
        if (prod.isConstant()) {
            String terminal = ((Terminal)prod.getItems().get(0)).getTerminal();
            if (prod.getSort().equals("KLabel")) {
                return KLabelConstant.of(terminal, context);
            }
            if (prod.getSort().equals("#Bool")) {
                return BoolBuiltin.kAppOf(terminal);
            }
            if (prod.getSort().equals("#Int")) {
                return IntBuiltin.kAppOf(terminal);
            }
            if (prod.getSort().equals("#String")) {
                return StringBuiltin.kAppOf(terminal);
            }
            return GenericToken.kAppOf(prod.getSort(), terminal);
        }
        if (prod.isLexical()) {
            return KApp.of(KLabelConstant.of("#token", context), StringBuiltin.kAppOf(prod.getSort()), Variable.getFreshVar("String"));
        }
        TermCons t = new TermCons(prod.getSort(), prod.getCons(), context);
        if (prod.isListDecl()) {
            t.getContents().add(Variable.getFreshVar(((UserList)prod.getItems().get(0)).getSort()));
            t.getContents().add(Variable.getFreshVar(prod.getSort()));
            return t;
        }
        for (ProductionItem item : prod.getItems()) {
            if (!(item instanceof Sort)) continue;
            t.getContents().add(Variable.getFreshVar(((Sort)item).getName()));
        }
        return t;
    }

    public static boolean isAnonVar(Variable node) {
        return node.getName().startsWith("_");
    }

    public static boolean isBuiltinSort(String sort) {
        return sort.equals("#Bool") || sort.equals("#Int") || sort.equals("#String") || sort.equals("#Float") || sort.equals("#Prop") || sort.equals("#ModelCheckerState") || sort.equals("#ModelCheckResult");
    }

    public static boolean isDataSort(String sort) {
        return sort.equals("#Bool") || sort.equals("#Int") || sort.equals("#String");
    }

    public static boolean isComputationSort(String sort) {
        return sort.equals("K") || sort.equals("KItem") || !MetaK.isKSort(sort);
    }

    public static String getListUnitLabel(String sep) {
        return "'.List{\"" + sep + "\"}";
    }

    public static List<Cell> getTopCells(Term t, Context context) {
        final ArrayList<Cell> cells = new ArrayList<Cell>();
        t.accept(new BasicVisitor(context){

            @Override
            public void visit(Cell node) {
                cells.add(node);
            }
        });
        return cells;
    }

    public static List<String> getAllCellLabels(Term t, Context context) {
        final ArrayList<String> cells = new ArrayList<String>();
        t.accept(new BasicVisitor(context){

            @Override
            public void visit(Cell node) {
                cells.add(node.getLabel());
                super.visit(node);
            }
        });
        return cells;
    }

    public static Collection createCollection(Term contents, KSort sort) {
        ArrayList<Term> col = new ArrayList<Term>();
        col.add(contents);
        switch (sort) {
            case Bag: {
                return new Bag(col);
            }
            case List: {
                return new org.kframework.kil.List(col);
            }
            case Set: {
                return new Set(col);
            }
            case Map: {
                return new Map(col);
            }
            case K: {
                return new KSequence(col);
            }
        }
        return null;
    }

    static {
        kModules.add("K-BUILTINS");
        kModules.add("K-CONDITION-SEARCH");
        kModules.add("K-CONTEXTS");
        kModules.add("K-RULES");
        kModules.add("K-SENTENCE");
        kModules.add("K-STRICNESS");
        kModules.add("K-TECHNIQUE");
        kModules.add("K-WHERE");
        kModules.add("K-WRAPPERS-LABELS");
        anywheres = new HashSet<Attribute>();
        anywheres.add(new Attribute("anywhere", ""));
        anywheres.add(new Attribute("macro", ""));
        anywheres.add(new Attribute("predicate", ""));
        anywheres.add(new Attribute("function", ""));
    }

    public static class Constants {
        public static final String anyVarSymbol = "_";
        public static final String heatingTag = "heat";
        public static final String coolingTag = "cool";
        public static final String hole = "[]";
        public static final String freshCons = "Bool1FreshSyn";
        public static final String plusIntCons = "Int1PlusSyn";
        public static final String generatedTopCellLabel = "generatedTop";
        public static final String pathCondition = "path-condition";
        public static final String generatedCfgAbsTopCellLabel = "___CONTEXT_ABSTRACTION_TOP_CELL___";
    }
}

