/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.compile.utils;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.kframework.compile.transformers.AddKCell;
import org.kframework.compile.transformers.AddTopCellRules;
import org.kframework.compile.transformers.FlattenSyntax;
import org.kframework.compile.transformers.ResolveAnonymousVariables;
import org.kframework.compile.transformers.ResolveContextAbstraction;
import org.kframework.compile.transformers.ResolveListOfK;
import org.kframework.compile.transformers.ResolveOpenCells;
import org.kframework.compile.transformers.ResolveSyntaxPredicates;
import org.kframework.compile.utils.CompilerStepDone;
import org.kframework.compile.utils.CompilerSteps;
import org.kframework.compile.utils.ConfigurationStructureVisitor;
import org.kframework.kil.Definition;
import org.kframework.kil.Rule;
import org.kframework.kil.Variable;
import org.kframework.kil.loader.Context;
import org.kframework.parser.concrete.disambiguate.CollectVariablesVisitor;

public class RuleCompilerSteps
extends CompilerSteps<Rule> {
    private Set<Variable> vars;

    public Set<Variable> getVars() {
        return this.vars;
    }

    public RuleCompilerSteps(Definition def, Context context) {
        super(context);
        this.add(new AddKCell(context));
        this.add(new AddTopCellRules(context));
        this.add(new ResolveAnonymousVariables(context));
        this.add(new ResolveSyntaxPredicates(context));
        this.add(new ResolveListOfK(context));
        this.add(new FlattenSyntax(context));
        ConfigurationStructureVisitor cfgStrVisitor = new ConfigurationStructureVisitor(context);
        def.accept(cfgStrVisitor);
        context.setMaxConfigurationLevel(cfgStrVisitor.getMaxLevel());
        ResolveContextAbstraction resolveContextAbstraction = new ResolveContextAbstraction(context);
        this.add(resolveContextAbstraction);
        this.add(new ResolveOpenCells(context));
    }

    @Override
    public Rule compile(Rule def, String stepName) throws CompilerStepDone {
        CollectVariablesVisitor collectVars = new CollectVariablesVisitor(this.context);
        def.accept(collectVars);
        this.vars = new HashSet<Variable>();
        for (List<Variable> collectedVars : collectVars.getVars().values()) {
            this.vars.add(collectedVars.get(0));
        }
        return super.compile(def, stepName);
    }
}

