/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.kagreg;

import java.util.ArrayList;
import java.util.List;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Module;
import org.kframework.kil.PriorityBlock;
import org.kframework.kil.Production;
import org.kframework.kil.ProductionItem;
import org.kframework.kil.Sort;
import org.kframework.kil.Syntax;
import org.kframework.kil.Terminal;
import org.kframework.kil.loader.AddConsesVisitor;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.CopyOnWriteTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;

public class AddSortLabels
extends CopyOnWriteTransformer {
    protected final List<String> labeledSorts;

    public AddSortLabels(Context context, List<String> labeledSorts) {
        super("AddSortLabels", context);
        this.labeledSorts = labeledSorts;
    }

    @Override
    public ASTNode transform(Module module) throws TransformerException {
        if (module.isPredefined()) {
            return module;
        }
        return super.transform(module);
    }

    @Override
    public ASTNode transform(Syntax syntax) throws TransformerException {
        if (this.labeledSorts.contains(syntax.getSort().getName())) {
            return syntax;
        }
        this.labeledSorts.add(syntax.getSort().getName());
        ArrayList<ProductionItem> productionItems = new ArrayList<ProductionItem>();
        productionItems.add(new Terminal("L" + syntax.getSort()));
        productionItems.add(new Sort("Id"));
        productionItems.add(new Terminal(":"));
        productionItems.add(syntax.getSort());
        Production production = new Production(syntax.getSort(), productionItems);
        AddConsesVisitor acv = new AddConsesVisitor(this.context);
        production.accept(acv);
        List<PriorityBlock> priorityBlocks = syntax.getPriorityBlocks();
        if (priorityBlocks.size() == 0) {
            PriorityBlock priorityBlock = new PriorityBlock();
            ArrayList<Production> productions = new ArrayList<Production>();
            productions.add(production);
            priorityBlock.setProductions(productions);
            priorityBlocks.add(priorityBlock);
        } else {
            priorityBlocks.get(priorityBlocks.size() - 1).getProductions().add(production);
        }
        syntax.setPriorityBlocks(priorityBlocks);
        return syntax;
    }
}

