/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.kagreg;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.kframework.backend.unparser.Indenter;
import org.kframework.backend.unparser.UnparserFilter;
import org.kframework.compile.transformers.AddKCell;
import org.kframework.kagreg.AddSortLabels;
import org.kframework.kagreg.AppendRenameStrategy;
import org.kframework.kagreg.CollectImportsVisitor;
import org.kframework.kagreg.RenameCellsTransformer;
import org.kframework.kagreg.RenameVariablesTransformer;
import org.kframework.kil.Configuration;
import org.kframework.kil.ConfigurationNotFound;
import org.kframework.kil.ConfigurationNotUnique;
import org.kframework.kil.Definition;
import org.kframework.kil.Import;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.parser.DefinitionLoader;
import org.kframework.parser.concrete.KParser;
import org.kframework.utils.Error;
import org.kframework.utils.errorsystem.KException;
import org.kframework.utils.file.FileUtil;
import org.kframework.utils.general.GlobalSettings;

public class KagregFrontEnd {
    public static void kagreg(String[] args) throws IOException, TransformerException {
        String msg;
        File errorFile;
        if (args.length != 2) {
            Error.report("There must be exactly two K definitions as arguments to kagreg.");
        }
        String firstDefinitionFileName = args[0];
        String secondDefinitionFileName = args[1];
        File firstDefinitionFile = new File(firstDefinitionFileName);
        File secondDefinitionFile = new File(secondDefinitionFileName);
        if (!firstDefinitionFile.exists()) {
            errorFile = firstDefinitionFile;
            firstDefinitionFile = new File(firstDefinitionFileName + ".k");
            if (!firstDefinitionFile.exists()) {
                msg = "File: " + errorFile.getName() + "(.k) not found.";
                GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, msg, errorFile.getAbsolutePath(), "File system."));
            }
        }
        if (!secondDefinitionFile.exists()) {
            errorFile = secondDefinitionFile;
            secondDefinitionFile = new File(secondDefinitionFileName + ".k");
            if (!secondDefinitionFile.exists()) {
                msg = "File: " + errorFile.getName() + "(.k) not found.";
                GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, msg, errorFile.getAbsolutePath(), "File system."));
            }
        }
        GlobalSettings.verbose = true;
        String firstLang = FileUtil.getMainModule(firstDefinitionFile.getName());
        String secondLang = FileUtil.getMainModule(secondDefinitionFile.getName());
        Context context1 = new Context();
        context1.dotk = new File(firstDefinitionFile.getCanonicalFile().getParent() + File.separator + ".k");
        context1.dotk.mkdirs();
        Definition firstDef = DefinitionLoader.loadDefinition(firstDefinitionFile, firstLang, true, context1);
        firstDef = (Definition)firstDef.accept(new AddKCell(context1));
        firstDef = (Definition)firstDef.accept(new RenameCellsTransformer(new AppendRenameStrategy("1"), context1));
        firstDef = (Definition)firstDef.accept(new RenameVariablesTransformer(new AppendRenameStrategy("1"), context1));
        CollectImportsVisitor collectImportsVisitor1 = new CollectImportsVisitor(context1, false);
        collectImportsVisitor1.visit(firstDef);
        List<Import> imports1 = collectImportsVisitor1.getImports();
        GlobalSettings.verbose = true;
        KParser.reset();
        Context context2 = new Context();
        assert (context2 != null);
        context2.dotk = new File(secondDefinitionFile.getCanonicalFile().getParent() + File.separator + ".k");
        context2.dotk.mkdirs();
        Definition secondDef = DefinitionLoader.loadDefinition(secondDefinitionFile, secondLang, true, context2);
        secondDef = (Definition)secondDef.accept(new AddKCell(context2));
        secondDef = (Definition)secondDef.accept(new RenameCellsTransformer(new AppendRenameStrategy("2"), context2));
        secondDef = (Definition)secondDef.accept(new RenameVariablesTransformer(new AppendRenameStrategy("2"), context2));
        CollectImportsVisitor collectImportsVisitor2 = new CollectImportsVisitor(context2, false);
        collectImportsVisitor2.visit(secondDef);
        List<Import> imports2 = collectImportsVisitor2.getImports();
        Configuration firstConf = null;
        try {
            firstConf = firstDef.getSingletonConfiguration();
        }
        catch (ConfigurationNotUnique e) {
            System.err.println("Expecting a unique configuration in the first definition; found several.");
            return;
        }
        catch (ConfigurationNotFound e) {
            System.err.println("The first definition must have a configuration; found none.");
            return;
        }
        Configuration secondConf = null;
        try {
            secondConf = secondDef.getSingletonConfiguration();
        }
        catch (ConfigurationNotUnique e) {
            System.err.println("Expecting a unique configuration in the second definition; found several.");
            return;
        }
        catch (ConfigurationNotFound e) {
            System.err.println("The second definition must have a configuration; found none.");
            return;
        }
        Indenter indenter = new Indenter();
        indenter.write("module RESULT");
        indenter.endLine();
        indenter.indent(UnparserFilter.TAB);
        ArrayList<Import> allImports = new ArrayList<Import>();
        allImports.addAll(imports1);
        allImports.addAll(imports2);
        for (Import i : allImports) {
            if (i.getName().endsWith("-SYNTAX") || i.getName().startsWith("AUTO-INCLUDED")) continue;
            indenter.write("imports " + i.getName());
            indenter.endLine();
        }
        indenter.endLine();
        ArrayList<String> labeledSorts = new ArrayList<String>();
        labeledSorts.add("KResult");
        AddSortLabels addSortLabels1 = new AddSortLabels(context1, labeledSorts);
        firstDef = (Definition)addSortLabels1.transform(firstDef);
        AddSortLabels addSortLabels2 = new AddSortLabels(context2, labeledSorts);
        secondDef = (Definition)addSortLabels2.transform(secondDef);
        UnparserFilter unparserFirst = new UnparserFilter(context1);
        unparserFirst.setIndenter(indenter);
        unparserFirst.setForEquivalence();
        unparserFirst.visit(firstDef);
        UnparserFilter unparserSecond = new UnparserFilter(context2);
        unparserSecond.setIndenter(indenter);
        unparserSecond.setForEquivalence();
        unparserSecond.visit(secondDef);
        indenter.write("configuration");
        indenter.endLine();
        indenter.indent(UnparserFilter.TAB);
        indenter.write("<aggregation>");
        indenter.endLine();
        indenter.indent(UnparserFilter.TAB);
        indenter.indent(UnparserFilter.TAB);
        indenter.write("<first>");
        indenter.endLine();
        indenter.indent(UnparserFilter.TAB);
        UnparserFilter unparserFirstConfiguration = new UnparserFilter(context1);
        unparserFirstConfiguration.setIndenter(indenter);
        unparserFirstConfiguration.setInConfiguration(true);
        firstConf.getBody().accept(unparserFirstConfiguration);
        indenter.endLine();
        indenter.unindent();
        indenter.write("</first>");
        indenter.endLine();
        indenter.unindent();
        indenter.write("<second>");
        indenter.endLine();
        indenter.indent(UnparserFilter.TAB);
        UnparserFilter unparserSecondConfiguration = new UnparserFilter(context2);
        unparserSecondConfiguration.setIndenter(indenter);
        unparserSecondConfiguration.setInConfiguration(true);
        secondConf.getBody().accept(unparserSecondConfiguration);
        indenter.endLine();
        indenter.unindent();
        indenter.write("</second>");
        indenter.endLine();
        indenter.unindent();
        indenter.write("</aggregation>");
        indenter.endLine();
        indenter.unindent();
        indenter.unindent();
        indenter.endLine();
        indenter.write("endmodule");
        indenter.endLine();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter("result.k"));){
            writer.write(indenter.toString());
        }
    }
}

