/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.kast;

import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.kframework.utils.ActualPosixParser;
import org.kframework.utils.Error;

public class KastOptionsParser {
    Options options;
    HelpFormatter help;
    private Options optionsStandard;
    private Options optionsExperimental;
    private ArrayList<Option> optionList = new ArrayList();

    private void addOptionWrapper(Option opt, boolean isStandard) {
        this.options.addOption(opt);
        this.optionList.add(opt);
        if (isStandard) {
            this.optionsStandard.addOption(opt);
        } else {
            this.optionsExperimental.addOption(opt);
        }
    }

    private void addOptionS(Option opt) {
        this.addOptionWrapper(opt, true);
    }

    private void addOptionE(Option opt) {
        this.addOptionWrapper(opt, false);
    }

    public KastOptionsParser() {
        this.options = new Options();
        this.help = new HelpFormatter();
        this.optionsStandard = new Options();
        this.optionsExperimental = new Options();
        OptionBuilder.withLongOpt("help");
        OptionBuilder.withDescription("Print this help message.");
        this.addOptionS(OptionBuilder.create("h"));
        OptionBuilder.withLongOpt("version");
        OptionBuilder.withDescription("Print version information.");
        this.addOptionS(OptionBuilder.create());
        OptionBuilder.withLongOpt("verbose");
        OptionBuilder.withDescription("Verbose output.");
        this.addOptionS(OptionBuilder.create("v"));
        OptionBuilder.withLongOpt("directory");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("dir");
        OptionBuilder.withDescription("Path to the directory in which the kompiled K definition resides. The default is the current directory.");
        this.addOptionS(OptionBuilder.create("d"));
        OptionBuilder.withLongOpt("expression");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("string");
        OptionBuilder.withDescription("An expression to parse passed on the command line. Note that positional arguments are ignored when this option is given.");
        this.addOptionS(OptionBuilder.create("e"));
        OptionBuilder.withLongOpt("parser");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("parser");
        OptionBuilder.withDescription("Choose a parser. <parser> is either [program|ground|rule|binary]. (Default: program).");
        this.addOptionS(OptionBuilder.create());
        OptionBuilder.withLongOpt("sort");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("string");
        OptionBuilder.withDescription("The start sort for the default parser. (The default is the sort of $PGM from the configuration.)");
        this.addOptionS(OptionBuilder.create());
        OptionBuilder.withLongOpt("help-experimental");
        OptionBuilder.withDescription("Print help on non-standard options.");
        this.addOptionS(OptionBuilder.create("X"));
        OptionBuilder.withLongOpt("fast-kast");
        OptionBuilder.withDescription("Using the (experimental) faster C SDF parser.");
        this.addOptionE(OptionBuilder.create());
        OptionBuilder.withLongOpt("pretty");
        OptionBuilder.withDescription("Pretty print the output.");
        this.addOptionE(OptionBuilder.create());
        OptionBuilder.withLongOpt("tabsize");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("num");
        OptionBuilder.withDescription("How many spaces to use for each indentation level.");
        this.addOptionE(OptionBuilder.create());
        OptionBuilder.withLongOpt("max-width");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("num");
        OptionBuilder.withDescription("Line will be split before <num> chars.");
        this.addOptionE(OptionBuilder.create());
        OptionBuilder.withLongOpt("aux-tabsize");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("num");
        OptionBuilder.withDescription("How many spaces to indent lines which do not fit into max-width. (Default: 2).");
        this.addOptionE(OptionBuilder.create());
        OptionBuilder.withLongOpt("nextline");
        OptionBuilder.withDescription("Force newline before first argument.");
        this.addOptionE(OptionBuilder.create());
    }

    public CommandLine parse(String[] cmd) {
        ActualPosixParser parser = new ActualPosixParser();
        try {
            CommandLine cl = parser.parse(this.options, cmd);
            return cl;
        }
        catch (ParseException e) {
            Error.silentReport(e.getLocalizedMessage());
            return null;
        }
    }

    public Options getOptions() {
        return this.options;
    }

    public HelpFormatter getHelp() {
        return this.help;
    }

    public Options getOptionsStandard() {
        return this.optionsStandard;
    }

    public Options getOptionsExperimental() {
        return this.optionsExperimental;
    }

    public ArrayList<Option> getOptionList() {
        return this.optionList;
    }
}

