/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.kcheck;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.kframework.utils.ActualPosixParser;
import org.kframework.utils.Error;

public class KCheckOptionsParser {
    Options options = new Options();
    HelpFormatter help = new HelpFormatter();

    public KCheckOptionsParser() {
        OptionGroup main = new OptionGroup();
        Option def = new Option("d", "definition", true, "main file to kompile");
        main.addOption(def);
        OptionGroup prove = new OptionGroup();
        Option prove_opt = new Option("prove", true, "file containing reachability rules");
        prove.addOption(prove_opt);
        OptionGroup pgmG = new OptionGroup();
        Option pgm = new Option("p", "pgm", true, "program file used to build the initial configuration ");
        pgmG.addOption(pgm);
        OptionGroup verb = new OptionGroup();
        Option help = new Option("h", "help", false, "prints this message and exits");
        Option verbose = new Option("v", "verbose", false, "verbose mode");
        verb.addOption(help);
        verb.addOption(verbose);
        OptionGroup simplify = new OptionGroup();
        Option sim = new Option("simplify", false, "simplify the path condition before sending it to SMT solver");
        simplify.addOption(sim);
        OptionGroup interfaceGroup = new OptionGroup();
        Option gui = new Option("interface", false, "start the user interface");
        interfaceGroup.addOption(gui);
        this.options.addOptionGroup(main);
        this.options.addOptionGroup(interfaceGroup);
        this.options.addOptionGroup(prove);
        this.options.addOptionGroup(verb);
        this.options.addOptionGroup(simplify);
        this.options.addOptionGroup(pgmG);
    }

    public CommandLine parse(String[] cmd) {
        ActualPosixParser parser = new ActualPosixParser();
        try {
            return parser.parse(this.options, cmd);
        }
        catch (ParseException e) {
            Error.silentReport(e.getLocalizedMessage());
            Error.helpExit(this.help, this.options);
            return null;
        }
    }

    public Options getOptions() {
        return this.options;
    }

    public HelpFormatter getHelp() {
        return this.help;
    }
}

