/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.kcheck;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.kframework.backend.Backend;
import org.kframework.backend.BasicBackend;
import org.kframework.backend.maude.MaudeBackend;
import org.kframework.backend.maude.MaudeBuiltinsFilter;
import org.kframework.backend.maude.krun.MaudeKRun;
import org.kframework.backend.symbolic.AddConditionToConfig;
import org.kframework.backend.symbolic.AddPathCondition;
import org.kframework.backend.symbolic.ReplaceConstants;
import org.kframework.backend.symbolic.TagUserRules;
import org.kframework.backend.unparser.UnparserFilter;
import org.kframework.compile.FlattenModules;
import org.kframework.compile.ResolveConfigurationAbstraction;
import org.kframework.compile.checks.CheckConfigurationCells;
import org.kframework.compile.checks.CheckRewrite;
import org.kframework.compile.checks.CheckVariables;
import org.kframework.compile.sharing.DeclareCellLabels;
import org.kframework.compile.tags.AddDefaultComputational;
import org.kframework.compile.tags.AddOptionalTags;
import org.kframework.compile.tags.AddStrictStar;
import org.kframework.compile.transformers.AddEmptyLists;
import org.kframework.compile.transformers.AddHeatingConditions;
import org.kframework.compile.transformers.AddK2SMTLib;
import org.kframework.compile.transformers.AddKCell;
import org.kframework.compile.transformers.AddKLabelConstant;
import org.kframework.compile.transformers.AddKStringConversion;
import org.kframework.compile.transformers.AddPredicates;
import org.kframework.compile.transformers.AddSemanticEquality;
import org.kframework.compile.transformers.AddSupercoolDefinition;
import org.kframework.compile.transformers.AddSuperheatRules;
import org.kframework.compile.transformers.AddSymbolicK;
import org.kframework.compile.transformers.AddTopCellConfig;
import org.kframework.compile.transformers.AddTopCellRules;
import org.kframework.compile.transformers.ContextsToHeating;
import org.kframework.compile.transformers.DesugarStreams;
import org.kframework.compile.transformers.FlattenSyntax;
import org.kframework.compile.transformers.FreezeUserFreezers;
import org.kframework.compile.transformers.FreshCondToFreshVar;
import org.kframework.compile.transformers.RemoveBrackets;
import org.kframework.compile.transformers.RemoveSyntacticCasts;
import org.kframework.compile.transformers.ResolveAnonymousVariables;
import org.kframework.compile.transformers.ResolveBinder;
import org.kframework.compile.transformers.ResolveBlockingInput;
import org.kframework.compile.transformers.ResolveBuiltins;
import org.kframework.compile.transformers.ResolveFreshVarMOS;
import org.kframework.compile.transformers.ResolveFunctions;
import org.kframework.compile.transformers.ResolveHybrid;
import org.kframework.compile.transformers.ResolveListOfK;
import org.kframework.compile.transformers.ResolveOpenCells;
import org.kframework.compile.transformers.ResolveRewrite;
import org.kframework.compile.transformers.ResolveSupercool;
import org.kframework.compile.transformers.ResolveSyntaxPredicates;
import org.kframework.compile.transformers.StrictnessToContexts;
import org.kframework.compile.utils.CheckVisitorStep;
import org.kframework.compile.utils.CompileDataStructures;
import org.kframework.compile.utils.CompilerStepDone;
import org.kframework.compile.utils.CompilerSteps;
import org.kframework.compile.utils.InitializeConfigurationStructure;
import org.kframework.compile.utils.RuleCompilerSteps;
import org.kframework.kcheck.ResolveRLFile;
import org.kframework.kcheck.utils.AddCheckConstants;
import org.kframework.kcheck.utils.AddCircularityRules;
import org.kframework.kcheck.utils.AddImplicationRules;
import org.kframework.kcheck.utils.AddPathConditionToCircularities;
import org.kframework.kcheck.utils.AddPathConditionToImplications;
import org.kframework.kcheck.utils.GeneratePrograms;
import org.kframework.kcheck.utils.MergeToTransformer;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Configuration;
import org.kframework.kil.Definition;
import org.kframework.kil.Rule;
import org.kframework.kil.Sentence;
import org.kframework.kil.Term;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.krun.K;
import org.kframework.krun.KRunExecutionException;
import org.kframework.krun.Main;
import org.kframework.krun.RunProcess;
import org.kframework.krun.api.KRunResult;
import org.kframework.krun.api.KRunState;
import org.kframework.krun.api.SearchResults;
import org.kframework.krun.api.SearchType;
import org.kframework.main.FirstStep;
import org.kframework.parser.DefinitionLoader;
import org.kframework.utils.BinaryLoader;
import org.kframework.utils.Stopwatch;
import org.kframework.utils.file.FileUtil;
import org.kframework.utils.file.KPaths;
import org.kframework.utils.general.GlobalSettings;

public class RLBackend
extends BasicBackend
implements Backend {
    public static int idx = 5000;
    List<ASTNode> reachabilityRules = new ArrayList<ASTNode>();
    private Term program = null;
    public static final String INTERNAL_KLABEL = "rrcondition";
    public static final String SIMPLIFY_KLABEL = "'simplifyBool";
    public static boolean SIMPLIFY = false;
    public static String PGM = null;
    List<Term> programs = new ArrayList<Term>();
    private List<Term> lpgms = null;
    private Term icontext = null;

    public RLBackend(Stopwatch sw, Context context) {
        super(sw, context);
    }

    @Override
    public Definition firstStep(Definition javaDef) {
        String fileSep = System.getProperty("file.separator");
        String propPath = KPaths.getKBase(false) + fileSep + "lib" + fileSep + "maude" + fileSep;
        Properties specialMaudeHooks = new Properties();
        Properties maudeHooks = new Properties();
        try {
            FileUtil.loadProperties(maudeHooks, propPath + "MaudeHooksMap.properties");
            FileUtil.loadProperties(specialMaudeHooks, propPath + "SpecialMaudeHooks.properties");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        MaudeBuiltinsFilter builtinsFilter = new MaudeBuiltinsFilter(maudeHooks, specialMaudeHooks, this.context);
        javaDef.accept(builtinsFilter);
        String mainModule = javaDef.getMainModule();
        StringBuilder builtins = new StringBuilder().append("mod ").append(mainModule).append("-BUILTINS is\n").append(" including ").append(mainModule).append("-BASE .\n").append((CharSequence)builtinsFilter.getResult()).append("endm\n");
        FileUtil.save(this.context.dotk.getAbsolutePath() + "/builtins.maude", builtins);
        this.sw.printIntermediate("Generating equations for hooks");
        return super.firstStep(javaDef);
    }

    @Override
    public void run(Definition javaDef) throws IOException {
        new MaudeBackend(this.sw, this.context).run(javaDef);
        String load = "load \"" + KPaths.getKBase(true) + KPaths.MAUDE_LIB_DIR + "/k-prelude\"\n";
        String maudeLib = GlobalSettings.lib.equals("") ? "" : "load " + KPaths.windowfyPath(new File(GlobalSettings.lib).getAbsolutePath()) + "\n";
        load = load + maudeLib;
        String mainModule = javaDef.getMainModule();
        StringBuilder main = new StringBuilder().append(load).append("load \"base.maude\"\n").append("load \"builtins.maude\"\n").append("mod ").append(mainModule).append(" is \n").append("  including ").append(mainModule).append("-BASE .\n").append("  including ").append(mainModule).append("-BUILTINS .\n").append("endm\n");
        FileUtil.save(this.context.dotk.getAbsolutePath() + "/" + "main.maude", main);
        this.context.kompiled = this.context.dotk;
        UnparserFilter unparserFilter = new UnparserFilter(this.context);
        javaDef.accept(unparserFilter);
        String unparsedText = unparserFilter.getResult();
        FileUtil.save(".symbolic.k", unparsedText);
        K.compiled_def = this.context.dotk.getAbsolutePath();
        K.main_module = mainModule;
        K.init(this.context);
        Rule defaultPattern = null;
        RuleCompilerSteps defaultPatternInfo = null;
        try {
            ASTNode pattern = DefinitionLoader.parsePattern(K.pattern, "Command line pattern", "MyBag", this.context);
            defaultPatternInfo = new RuleCompilerSteps(javaDef, this.context);
            pattern = defaultPatternInfo.compile(new Rule((Sentence)pattern), (String)null);
            defaultPattern = (Rule)pattern;
        }
        catch (TransformerException e1) {
            e1.printStackTrace();
        }
        catch (CompilerStepDone e) {
            e.printStackTrace();
        }
        MaudeKRun mkr = new MaudeKRun(this.context);
        mkr.setBackendOption("io", false);
        K.kompiled_cfg = (Configuration)BinaryLoader.load(K.compiled_def + "/configuration.bin");
        if (PGM != null) {
            RunProcess rp = new RunProcess();
            try {
                KRunResult<KRunState> res = mkr.run(Main.makeConfiguration(this.program, null, rp, false, this.context));
                this.icontext = res.getResult().getRawResult();
            }
            catch (KRunExecutionException e1) {
                e1.printStackTrace();
            }
            catch (TransformerException e) {
                e.printStackTrace();
            }
        }
        if (this.icontext != null) {
            for (Term lpgm : this.lpgms) {
                try {
                    Term merged = this.mergeLeftIntoRight(lpgm, this.icontext);
                    this.programs.add(merged);
                }
                catch (TransformerException e) {
                    e.printStackTrace();
                }
            }
        } else {
            this.programs = this.lpgms;
        }
        if (GlobalSettings.verbose) {
            for (int i = 0; i < this.programs.size(); ++i) {
                System.out.println("PGM(" + i + "): " + this.programs.get(i));
            }
        }
        for (Term pgm : this.programs) {
            try {
                System.out.println("Verifying PGM(" + this.programs.indexOf(pgm) + ") ...");
                KRunResult<SearchResults> result = mkr.search(null, null, SearchType.FINAL, defaultPattern, pgm, defaultPatternInfo);
                System.out.println("Result: " + result + "\n\n");
            }
            catch (KRunExecutionException e) {
                e.printStackTrace();
            }
        }
    }

    private Term mergeLeftIntoRight(Term lpgm, Term icontext) throws TransformerException {
        Term context = icontext.shallowCopy();
        MergeToTransformer mtt = new MergeToTransformer(this.context, lpgm);
        context = (Term)context.accept(mtt);
        return context;
    }

    @Override
    public String getDefaultStep() {
        return "LastStep";
    }

    @Override
    public CompilerSteps<Definition> getCompilationSteps() {
        CompilerSteps<Definition> steps = new CompilerSteps<Definition>(this.context);
        steps.add(new FirstStep(this, this.context));
        steps.add(new CheckVisitorStep(new CheckConfigurationCells(this.context), this.context));
        steps.add(new RemoveBrackets(this.context));
        steps.add(new AddEmptyLists(this.context));
        steps.add(new RemoveSyntacticCasts(this.context));
        steps.add(new CheckVisitorStep(new CheckVariables(this.context), this.context));
        steps.add(new CheckVisitorStep(new CheckRewrite(this.context), this.context));
        steps.add(new FlattenModules(this.context));
        steps.add(new StrictnessToContexts(this.context));
        steps.add(new FreezeUserFreezers(this.context));
        steps.add(new ContextsToHeating(this.context));
        steps.add(new AddSupercoolDefinition(this.context));
        steps.add(new AddHeatingConditions(this.context));
        steps.add(new AddSuperheatRules(this.context));
        steps.add(new DesugarStreams(this.context, false));
        steps.add(new ResolveFunctions(this.context));
        steps.add(new TagUserRules(this.context));
        steps.add(new AddKCell(this.context));
        steps.add(new AddSymbolicK(this.context));
        ResolveRLFile rl = new ResolveRLFile(this.context, PGM);
        this.reachabilityRules = rl.getReachabilityRules();
        this.program = rl.getPgm();
        steps.add(new AddCheckConstants(this.context, this.reachabilityRules.size()));
        steps.add(new AddCircularityRules(this.context, this.reachabilityRules));
        steps.add(new AddImplicationRules(this.context, this.reachabilityRules));
        steps.add(new AddSemanticEquality(this.context));
        steps.add(new FreshCondToFreshVar(this.context));
        steps.add(new ResolveFreshVarMOS(this.context));
        steps.add(new AddTopCellConfig(this.context));
        AddConditionToConfig.PC = false;
        steps.add(new AddConditionToConfig(this.context));
        steps.add(new AddTopCellRules(this.context));
        steps.add(new ResolveBinder(this.context));
        steps.add(new ResolveAnonymousVariables(this.context));
        steps.add(new ResolveBlockingInput(this.context, false));
        steps.add(new AddK2SMTLib(this.context));
        steps.add(new AddPredicates(this.context));
        steps.add(new ResolveSyntaxPredicates(this.context));
        steps.add(new ResolveBuiltins(this.context));
        steps.add(new ResolveListOfK(this.context));
        steps.add(new FlattenSyntax(this.context));
        steps.add(new InitializeConfigurationStructure(this.context));
        steps.add(new AddKStringConversion(this.context));
        steps.add(new AddKLabelConstant(this.context));
        steps.add(new ResolveHybrid(this.context));
        steps.add(new ResolveConfigurationAbstraction(this.context));
        steps.add(new ResolveOpenCells(this.context));
        steps.add(new ResolveRewrite(this.context));
        steps.add(new CompileDataStructures(this.context));
        steps.add(new ReplaceConstants(this.context));
        steps.add(new AddPathCondition(this.context));
        steps.add(new AddPathConditionToCircularities(this.context, this.reachabilityRules));
        steps.add(new AddPathConditionToImplications(this.context, this.reachabilityRules));
        GeneratePrograms gp = new GeneratePrograms(this.context, this.reachabilityRules);
        steps.add(gp);
        this.lpgms = gp.getPrograms();
        steps.add(new ResolveSupercool(this.context));
        steps.add(new AddStrictStar(this.context));
        steps.add(new AddDefaultComputational(this.context));
        steps.add(new AddOptionalTags(this.context));
        steps.add(new DeclareCellLabels(this.context));
        return steps;
    }
}

