/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.kcheck;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.kframework.kcheck.RLBackend;
import org.kframework.kcheck.RetrieveRRVisitor;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Definition;
import org.kframework.kil.Term;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.CopyOnWriteTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.parser.DefinitionLoader;
import org.kframework.parser.ProgramLoader;
import org.kframework.utils.file.FileUtil;
import org.kframework.utils.general.GlobalSettings;

public class ResolveRLFile
extends CopyOnWriteTransformer {
    private List<ASTNode> reachabilityRules = new ArrayList<ASTNode>();
    private Term program = null;

    public ResolveRLFile(Context context, String pgmFilePath) {
        super("Parse RL input file", context);
        String rlFileContent = FileUtil.getFileContent(GlobalSettings.CHECK);
        context.kompiled = context.dotk.getAbsoluteFile();
        Definition rlModule = DefinitionLoader.parseString(rlFileContent, GlobalSettings.CHECK, context);
        RetrieveRRVisitor rrrv = new RetrieveRRVisitor(context);
        rlModule.accept(rrrv);
        this.reachabilityRules = rrrv.getRules();
        if (RLBackend.PGM != null) {
            String pgmContent = FileUtil.getFileContent(pgmFilePath);
            try {
                context.kompiled = context.dotk.getAbsoluteFile();
                this.program = (Term)ProgramLoader.loadPgmAst(pgmContent, GlobalSettings.CHECK, "K", context);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            catch (TransformerException e1) {
                e1.printStackTrace();
            }
        }
    }

    public List<ASTNode> getReachabilityRules() {
        return this.reachabilityRules;
    }

    public Term getPgm() {
        return this.program;
    }
}

