/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.kcheck.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import org.kframework.krun.RunProcess;
import org.kframework.ktest.ExecNames;
import org.kframework.utils.general.GlobalSettings;

public class KCheckMainWindow
extends JFrame
implements KeyListener,
ActionListener {
    private JPanel mainPanel = new JPanel(new GridBagLayout());
    private JTextPane pi1;
    private JTextPane phi1;
    private JTextPane pi2;
    private JTextPane phi2;
    private JScrollPane sphi2;
    private JScrollPane spi2;
    private JScrollPane sphi1;
    private JScrollPane spi1;
    private JLabel and;
    private JTextPane console;
    private JScrollPane sConsole;
    private JTextField def;
    private JButton loadDef;
    private JTextField pgm;
    private JButton loadPgm;
    private JTextField file;
    private JButton loadFile;
    private JButton addToFile;
    private JButton kcheckFile;
    private final String BROWSE_FILE = "browse_file";
    private final String BROWSE_PGM = "browse_pgm";
    private final String BROWSE_DEF = "browse_def";
    private final String VERIF = "verify";
    private final String ADD = "add";
    private JDialog dialog;
    private File cDir;

    public KCheckMainWindow() {
        this.mainPanel.setVisible(true);
        this.mainPanel.setDoubleBuffered(true);
        this.mainPanel.setBackground(Color.lightGray);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.mainPanel.setPreferredSize(new Dimension(dimension.width - dimension.width / 5, dimension.height - dimension.height / 10));
        this.getContentPane().add(this.mainPanel);
        this.pack();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        int levely = 0;
        JLabel defLabel = new JLabel("Definition: ");
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = levely;
        this.mainPanel.add((Component)defLabel, c);
        this.def = new JTextField();
        this.def.setEditable(false);
        c.anchor = 13;
        c.gridx = 1;
        c.gridy = levely;
        this.mainPanel.add((Component)this.def, c);
        this.loadDef = new JButton("Setup K definition");
        this.loadDef.setActionCommand("browse_def");
        this.loadDef.addActionListener(this);
        c.anchor = 17;
        c.gridx = 3;
        c.gridy = levely++;
        this.mainPanel.add((Component)this.loadDef, c);
        JLabel pgmLabel = new JLabel("Program: ");
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = levely;
        this.mainPanel.add((Component)pgmLabel, c);
        this.pgm = new JTextField();
        this.pgm.setEditable(false);
        c.anchor = 13;
        c.gridx = 1;
        c.gridy = levely;
        this.mainPanel.add((Component)this.pgm, c);
        this.loadPgm = new JButton("Browse program");
        this.loadPgm.setActionCommand("browse_pgm");
        this.loadPgm.addActionListener(this);
        c.anchor = 17;
        c.gridx = 3;
        c.gridy = levely++;
        this.mainPanel.add((Component)this.loadPgm, c);
        JLabel piphi = new JLabel("\u03c0 \u2227 \u03c6:");
        c.anchor = 256;
        c.gridx = 0;
        c.gridy = levely;
        this.mainPanel.add((Component)piphi, c);
        Dimension leftSize = new Dimension(dimension.width / 3, dimension.height / 4);
        c.anchor = 12;
        c.gridx = 1;
        c.gridy = levely;
        this.pi1 = this.initializeEditPane(this);
        this.spi1 = this.wrapScrollEditPane(this.pi1, leftSize);
        this.mainPanel.add((Component)this.spi1, c);
        this.and = new JLabel("\u2227");
        c.anchor = 256;
        c.gridx = 2;
        c.gridy = levely;
        this.mainPanel.add((Component)this.and, c);
        Dimension rightSize = new Dimension(dimension.width / 4, dimension.height / 4);
        this.phi1 = this.initializeEditPane(this);
        this.sphi1 = this.wrapScrollEditPane(this.phi1, rightSize);
        c.anchor = 12;
        c.gridx = 3;
        c.gridy = levely++;
        this.mainPanel.add((Component)this.sphi1, c);
        JLabel piphi_ = new JLabel("\u03c0' \u2227 \u03c6':");
        c.anchor = 256;
        c.gridx = 0;
        c.gridy = levely;
        this.mainPanel.add((Component)piphi_, c);
        c.anchor = 12;
        c.gridx = 1;
        c.gridy = levely;
        this.pi2 = this.initializeEditPane(this);
        this.spi2 = this.wrapScrollEditPane(this.pi2, leftSize);
        this.mainPanel.add((Component)this.spi2, c);
        JLabel and_2 = new JLabel("\u2227");
        c.anchor = 256;
        c.gridx = 2;
        c.gridy = levely;
        this.mainPanel.add((Component)and_2, c);
        this.phi2 = this.initializeEditPane(this);
        this.sphi2 = this.wrapScrollEditPane(this.phi2, rightSize);
        c.anchor = 12;
        c.gridx = 3;
        c.gridy = levely++;
        this.mainPanel.add((Component)this.sphi2, c);
        JLabel fileLabel = new JLabel("File: ");
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = levely;
        this.mainPanel.add((Component)fileLabel, c);
        this.file = new JTextField();
        this.file.setEditable(false);
        c.anchor = 13;
        c.gridx = 1;
        c.gridy = levely;
        this.mainPanel.add((Component)this.file, c);
        this.loadFile = new JButton("Browse file");
        this.loadFile.setActionCommand("browse_file");
        this.loadFile.addActionListener(this);
        c.anchor = 17;
        c.gridx = 3;
        c.gridy = levely++;
        this.mainPanel.add((Component)this.loadFile, c);
        this.addToFile = new JButton("Add \u03c0 \u2227 \u03c6 \u21d2 \u03c0' \u2227 \u03c6' to file");
        this.addToFile.setActionCommand("add");
        this.addToFile.addActionListener(this);
        c.anchor = 17;
        c.gridx = 1;
        c.gridy = levely;
        this.mainPanel.add((Component)this.addToFile, c);
        this.kcheckFile = new JButton("Verify file");
        this.kcheckFile.setActionCommand("verify");
        this.kcheckFile.addActionListener(this);
        c.anchor = 17;
        c.gridx = 3;
        c.gridy = levely++;
        this.mainPanel.add((Component)this.kcheckFile, c);
        JLabel consoleLabel = new JLabel("Console:");
        c.anchor = 18;
        c.gridx = 0;
        c.gridy = levely;
        this.mainPanel.add((Component)consoleLabel, c);
        Dimension consoleSize = new Dimension(dimension.width / 3, dimension.height / 4);
        this.console = this.initializeEditPane(this);
        this.sConsole = this.wrapScrollEditPane(this.console, consoleSize);
        c.anchor = 15;
        c.gridx = 1;
        c.gridy = levely;
        c.gridwidth = 3;
        this.mainPanel.add((Component)this.sConsole, c);
        this.setTitle("K verifier");
        this.setName("K Verif");
        this.setDefaultCloseOperation(3);
    }

    private JTextPane initializeEditPane(KeyListener keyListener) {
        JTextPane pane = new JTextPane();
        pane.setEditable(true);
        pane.setVisible(true);
        pane.addKeyListener(keyListener);
        return pane;
    }

    private JScrollPane wrapScrollEditPane(JTextPane pane, Dimension dimension) {
        JScrollPane scroll = new JScrollPane(pane);
        scroll.setPreferredSize(dimension);
        scroll.setVisible(true);
        return scroll;
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd;
        switch (cmd = e.getActionCommand()) {
            case "browse_file": {
                this.selectFile(this.file);
                GlobalSettings.CHECK = this.file.getText();
                break;
            }
            case "browse_pgm": {
                this.selectFile(this.pgm);
                if (this.pgm.getText().equals("null")) break;
                this.addToConsole("Running program " + this.pgm.getText());
                this.initPleaseWait("Running " + this.pgm.getText());
                RunProcess rpRun = new RunProcess();
                rpRun.execute(System.getenv(), KCheckMainWindow.getKrun(), this.pgm.getText(), "-d", new File(this.def.getText()).getParent());
                this.stopPleaseWait();
                this.addToConsole("Run command:\n" + KCheckMainWindow.getKrun() + " " + this.pgm.getText() + " " + "-d" + " " + new File(this.def.getText()).getParent());
                int exit = rpRun.getExitCode();
                this.addToConsole("Ended with code: " + exit);
                String output = rpRun.getStdout();
                String error = rpRun.getErr();
                this.addToConsole(output);
                this.addToConsole(error);
                break;
            }
            case "browse_def": {
                this.selectFile(this.def);
                if (this.def.getText().equals("null")) break;
                this.addToConsole("Loading " + this.def.getText());
                this.initPleaseWait("Compiling " + this.def.getText());
                RunProcess rp = new RunProcess();
                rp.execute(System.getenv(), KCheckMainWindow.getKompile(), this.def.getText(), "-v");
                this.stopPleaseWait();
                this.addToConsole("Started compilation:\n" + KCheckMainWindow.getKompile() + " " + this.def.getText() + " " + "-v");
                int exit = rp.getExitCode();
                this.addToConsole("Compilation ended with code: " + exit);
                String output = rp.getStdout();
                String error = rp.getErr();
                this.addToConsole(output);
                this.addToConsole(error);
                break;
            }
            case "add": {
                break;
            }
            case "verify": {
                if (this.file.getText().equals("null") || this.file.getText().equals("")) {
                    JOptionPane.showMessageDialog(this, "Please select a valid file for verification!");
                    break;
                }
                this.addToConsole("Verifying " + this.file.getText());
                this.initPleaseWait("Verifying " + this.file.getText());
                RunProcess rpVerif = new RunProcess();
                rpVerif.execute(System.getenv(), this.getKcheck(), this.def.getText(), "-prove", this.file.getText());
                this.stopPleaseWait();
                this.addToConsole("Started verification:\n" + this.getKcheck() + " " + this.def.getText() + " " + "-prove" + " " + this.file.getText());
                int exit = rpVerif.getExitCode();
                this.addToConsole("Verification ended with code: " + exit);
                String output = rpVerif.getStdout();
                String error = rpVerif.getErr();
                this.addToConsole(output);
                this.addToConsole(error);
            }
        }
    }

    private void initPleaseWait(String message) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JTextArea text = new JTextArea();
        text.setText(message);
        text.setPreferredSize(new Dimension(300, 200));
        text.setVisible(true);
        panel.add((Component)text, "Center");
        panel.setVisible(true);
        this.dialog = new JDialog();
        this.dialog.setLocationRelativeTo(this);
        this.dialog.setTitle("Please wait");
        this.dialog.add(panel);
        this.dialog.pack();
        this.dialog.setVisible(true);
    }

    private void stopPleaseWait() {
        this.dialog.setVisible(false);
        this.dialog.dispose();
    }

    private void addToConsole(String log) {
        if (log == null) {
            return;
        }
        this.console.setText(this.console.getText() + "\n" + log);
        this.console.repaint();
        this.console.revalidate();
    }

    private static String getKompile() {
        return ExecNames.getKompile().replace("/src", "");
    }

    private static String getKrun() {
        return ExecNames.getKrun().replace("/src", "");
    }

    public String getKcheck() {
        return ExecNames.getExecutable("kcheck").replace("/src", "");
    }

    private void selectFile(JTextField field) {
        int response;
        JFileChooser fc = new JFileChooser();
        if (this.cDir != null) {
            fc.setCurrentDirectory(this.cDir);
        }
        if ((response = fc.showOpenDialog(this)) == 0) {
            field.setBackground(Color.WHITE);
            field.setText(fc.getSelectedFile().getAbsolutePath());
            this.cDir = fc.getSelectedFile().getParentFile();
        } else {
            JOptionPane.showMessageDialog(this, "Please select a file.");
            field.setText("null");
            field.setBackground(Color.RED);
        }
    }
}

