/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.kcheck.utils;

import java.util.ArrayList;
import java.util.List;
import org.kframework.kcheck.utils.ExtractCellContent;
import org.kframework.kcheck.utils.ReachabilityRuleKILParser;
import org.kframework.kcheck.utils.RemoveLabel;
import org.kframework.kcheck.utils.SetCellContent;
import org.kframework.kcheck.utils.VariablesVisitor;
import org.kframework.kil.ASTNode;
import org.kframework.kil.BoolBuiltin;
import org.kframework.kil.KApp;
import org.kframework.kil.KLabelConstant;
import org.kframework.kil.KSequence;
import org.kframework.kil.Module;
import org.kframework.kil.ModuleItem;
import org.kframework.kil.Rule;
import org.kframework.kil.Sentence;
import org.kframework.kil.Term;
import org.kframework.kil.TermCons;
import org.kframework.kil.Variable;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.CopyOnWriteTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;

public class AddCircularityRules
extends CopyOnWriteTransformer {
    public static final String RRULE_ATTR = "reachability-rule";
    private List<ASTNode> reachabilityRules;

    public AddCircularityRules(Context context, List<ASTNode> reachabilityRules) {
        super("Add circularity rules", context);
        this.reachabilityRules = reachabilityRules;
    }

    @Override
    public ASTNode transform(Module node) throws TransformerException {
        ArrayList<ModuleItem> items = new ArrayList<ModuleItem>(node.getItems());
        Module module = node.shallowCopy();
        module.setItems(items);
        for (ASTNode rr : this.reachabilityRules) {
            if (!(rr instanceof Sentence)) continue;
            Sentence r = (Sentence)rr;
            ReachabilityRuleKILParser parser = new ReachabilityRuleKILParser(this.context);
            r.accept(parser);
            Term newPi = parser.getPi().shallowCopy();
            Variable K2 = Variable.getFreshVar("K");
            ExtractCellContent extract = new ExtractCellContent(this.context, "k");
            newPi.accept(extract);
            Term pgm = extract.getContent().shallowCopy();
            Term pgmprime = pgm.shallowCopy();
            RemoveLabel pl = new RemoveLabel(this.context);
            pgmprime = (Term)pgmprime.accept(pl);
            ArrayList<Term> cnt = new ArrayList<Term>();
            cnt.add(pgm);
            cnt.add(pgmprime);
            cnt.add(K2);
            KSequence newContent = new KSequence(cnt);
            SetCellContent app = new SetCellContent(this.context, newContent, "k");
            newPi = (Term)newPi.accept(app);
            Term newPiPrime = parser.getPi_prime().shallowCopy();
            SetCellContent appPrime = new SetCellContent(this.context, K2, "k");
            newPiPrime = (Term)newPiPrime.accept(appPrime);
            VariablesVisitor vvleft = new VariablesVisitor(this.context);
            parser.getPi().accept(vvleft);
            VariablesVisitor vvright = new VariablesVisitor(this.context);
            parser.getPi_prime().accept(vvright);
            ArrayList<Term> fresh = new ArrayList<Term>();
            for (Variable v : vvright.getVariables()) {
                if (AddCircularityRules.varInList(v, vvleft.getVariables())) continue;
                ArrayList<Term> vlist = new ArrayList<Term>();
                vlist.add(v);
                fresh.add(new TermCons(v.getSort(), "Bool1FreshSyn", vlist, this.context));
            }
            Term phi = parser.getPhi().shallowCopy();
            Term phiPrime = parser.getPhi_prime().shallowCopy();
            KApp rrcond = KApp.of(KLabelConstant.of("rrcondition", this.context), phi, phiPrime);
            fresh.add(rrcond);
            Term condition = this.andBool(fresh);
            Rule circRule = new Rule(newPi, newPiPrime, this.context);
            circRule.setRequires(condition);
            int correspondingIndex = this.reachabilityRules.indexOf(rr);
            circRule.addAttribute(RRULE_ATTR, correspondingIndex + "");
            items.add(circRule);
        }
        return module;
    }

    private Term andBool(List<Term> terms) {
        if (terms.size() == 0) {
            return BoolBuiltin.TRUE;
        }
        Term term = terms.get(0);
        terms.remove(0);
        return KApp.of(KLabelConstant.BOOL_ANDBOOL_KLABEL, term, this.andBool(terms));
    }

    public static boolean varInList(Variable v, List<Variable> vars) {
        for (Variable var : vars) {
            if (!v.getName().equals(var.getName())) continue;
            return true;
        }
        return false;
    }
}

