/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.kcheck.utils;

import java.util.List;
import org.kframework.kcheck.utils.AddCheckConstants;
import org.kframework.kcheck.utils.ReachabilityRuleKILParser;
import org.kframework.kcheck.utils.SetCellContent;
import org.kframework.kil.ASTNode;
import org.kframework.kil.BoolBuiltin;
import org.kframework.kil.KApp;
import org.kframework.kil.KLabelConstant;
import org.kframework.kil.KSequence;
import org.kframework.kil.Module;
import org.kframework.kil.ModuleItem;
import org.kframework.kil.Rule;
import org.kframework.kil.Sentence;
import org.kframework.kil.Term;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.CopyOnWriteTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;

public class AddImplicationRules
extends CopyOnWriteTransformer {
    public static final String IMPLRULE_ATTR = "implication-rule";
    private List<ASTNode> reachabilityRules;

    public AddImplicationRules(Context context, List<ASTNode> reachabilityRules) {
        super("Add rules for implication", context);
        this.reachabilityRules = reachabilityRules;
    }

    @Override
    public ASTNode transform(Module node) throws TransformerException {
        List<ModuleItem> items = node.getItems();
        node = node.shallowCopy();
        node.setItems(items);
        for (ASTNode rr : this.reachabilityRules) {
            if (!(rr instanceof Sentence)) continue;
            Sentence r = (Sentence)rr;
            ReachabilityRuleKILParser parser = new ReachabilityRuleKILParser(this.context);
            r.accept(parser);
            Term newPi = parser.getPi_prime().shallowCopy();
            Term implies = AddCheckConstants.getFreshImplicationForRule(this.reachabilityRules.indexOf(rr), this.context);
            SetCellContent app = new SetCellContent(this.context, implies, "k");
            newPi = (Term)newPi.accept(app);
            Term newPiPrime = parser.getPi_prime().shallowCopy();
            SetCellContent appPrime = new SetCellContent(this.context, KSequence.EMPTY, "k");
            newPiPrime = (Term)newPiPrime.accept(appPrime);
            Term phi = parser.getPhi().shallowCopy();
            Term phiPrime = parser.getPhi_prime().shallowCopy();
            KApp rrcond = KApp.of(KLabelConstant.of("rrcondition", this.context), phi, phiPrime);
            KApp condition = KApp.of(KLabelConstant.BOOL_ANDBOOL_KLABEL, rrcond, BoolBuiltin.TRUE);
            Rule implicationRule = new Rule(newPi, newPiPrime, this.context);
            implicationRule.setRequires(condition);
            int correspondingIndex = this.reachabilityRules.indexOf(rr);
            implicationRule.addAttribute(IMPLRULE_ATTR, correspondingIndex + "");
            items.add(implicationRule);
        }
        return node;
    }
}

