/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.kcheck.utils;

import java.util.List;
import org.kframework.backend.symbolic.AddConditionToConfig;
import org.kframework.backend.symbolic.AddPathCondition;
import org.kframework.kcheck.RLBackend;
import org.kframework.kcheck.utils.ExtractPatternless;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Cell;
import org.kframework.kil.KApp;
import org.kframework.kil.KLabelConstant;
import org.kframework.kil.Rewrite;
import org.kframework.kil.Rule;
import org.kframework.kil.Term;
import org.kframework.kil.Variable;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.CopyOnWriteTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;

public class AddPathConditionToCircularities
extends CopyOnWriteTransformer {
    public AddPathConditionToCircularities(Context context, List<ASTNode> reachabilityRules) {
        super("Add path condition to circularities", context);
    }

    @Override
    public ASTNode transform(Rule node) throws TransformerException {
        if (node.getAttribute("reachability-rule") != null && node.getBody() instanceof Rewrite) {
            Term cnd = node.getRequires();
            ExtractPatternless ep = new ExtractPatternless(this.context, false);
            cnd = (Term)cnd.accept(ep);
            Rewrite ruleBody = (Rewrite)node.getBody();
            Term left = ruleBody.getLeft().shallowCopy();
            Term right = ruleBody.getRight().shallowCopy();
            Variable psi = Variable.getFreshVar("K");
            Cell leftCell = new Cell();
            leftCell.setLabel("path-condition");
            leftCell.setEllipses(Cell.Ellipses.NONE);
            leftCell.setContents(psi);
            left = AddConditionToConfig.addSubcellToCell((Cell)left, leftCell);
            Cell rightCell = new Cell();
            rightCell.setLabel("path-condition");
            rightCell.setEllipses(Cell.Ellipses.NONE);
            rightCell.setContents(KApp.of(KLabelConstant.BOOL_ANDBOOL_KLABEL, KApp.of(KLabelConstant.BOOL_ANDBOOL_KLABEL, psi, ep.getPhi()), ep.getPhiPrime()));
            right = AddConditionToConfig.addSubcellToCell((Cell)right, rightCell);
            Term pc = KApp.of(KLabelConstant.BOOL_ANDBOOL_KLABEL, KApp.of(KLabelConstant.BOOL_ANDBOOL_KLABEL, psi, ep.getPhi()), ep.getPhiPrime());
            pc = AddPathCondition.checkSat(pc, this.context);
            Rule newRule = new Rule(left, right, this.context);
            KApp cc = KApp.of(KLabelConstant.BOOL_ANDBOOL_KLABEL, cnd, pc);
            if (RLBackend.SIMPLIFY) {
                cc = KApp.of(KLabelConstant.of("'simplifyBool", this.context), cc);
            }
            newRule.setRequires(cc);
            newRule.setAttributes(node.getAttributes().shallowCopy());
            return newRule;
        }
        return super.transform(node);
    }
}

