/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.kcheck.utils;

import java.util.ArrayList;
import java.util.List;
import org.kframework.backend.symbolic.AddConditionToConfig;
import org.kframework.kcheck.RLBackend;
import org.kframework.kcheck.utils.AddCircularityRules;
import org.kframework.kcheck.utils.ExtractPatternless;
import org.kframework.kcheck.utils.MakeFreshVariables;
import org.kframework.kcheck.utils.ReachabilityRuleKILParser;
import org.kframework.kcheck.utils.VariablesVisitor;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Cell;
import org.kframework.kil.KApp;
import org.kframework.kil.KLabelConstant;
import org.kframework.kil.Rewrite;
import org.kframework.kil.Rule;
import org.kframework.kil.StringBuiltin;
import org.kframework.kil.Term;
import org.kframework.kil.Variable;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.CopyOnWriteTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;

public class AddPathConditionToImplications
extends CopyOnWriteTransformer {
    private List<ASTNode> reachabilityRules;

    public AddPathConditionToImplications(Context context, List<ASTNode> reachabilityRules) {
        super("Add path condition to implication rules", context);
        this.reachabilityRules = reachabilityRules;
    }

    @Override
    public ASTNode transform(Rule node) throws TransformerException {
        if (node.getAttribute("implication-rule") != null && node.getBody() instanceof Rewrite) {
            int rIndex = Integer.parseInt(node.getAttribute("implication-rule"));
            ASTNode rrule = this.reachabilityRules.get(rIndex);
            ReachabilityRuleKILParser parser = new ReachabilityRuleKILParser(this.context);
            rrule.accept(parser);
            VariablesVisitor vvpi = new VariablesVisitor(this.context);
            parser.getPi().accept(vvpi);
            VariablesVisitor vvpiprime = new VariablesVisitor(this.context);
            parser.getPi_prime().accept(vvpiprime);
            ArrayList<Variable> fresh = new ArrayList<Variable>();
            for (Variable v : vvpi.getVariables()) {
                if (AddCircularityRules.varInList(v, vvpiprime.getVariables())) continue;
                fresh.add(v);
            }
            Term cnd = node.getRequires();
            ExtractPatternless ep = new ExtractPatternless(this.context, true);
            cnd = (Term)cnd.accept(ep);
            Rewrite ruleBody = (Rewrite)node.getBody();
            Term left = ruleBody.getLeft().shallowCopy();
            Term right = ruleBody.getRight().shallowCopy();
            Variable psi = Variable.getFreshVar("K");
            Cell leftCell = new Cell();
            leftCell.setLabel("path-condition");
            leftCell.setEllipses(Cell.Ellipses.NONE);
            leftCell.setContents(psi);
            left = AddConditionToConfig.addSubcellToCell((Cell)left, leftCell);
            Cell rightCell = new Cell();
            rightCell.setLabel("path-condition");
            rightCell.setEllipses(Cell.Ellipses.NONE);
            rightCell.setContents(psi);
            right = AddConditionToConfig.addSubcellToCell((Cell)right, rightCell);
            KApp implication = KApp.of(KLabelConstant.BOOL_ANDBOOL_KLABEL, psi, KApp.of(KLabelConstant.NOTBOOL_KLABEL, ep.getPhiPrime()));
            KApp unsat = StringBuiltin.kAppOf("unsat");
            KApp checkSat = KApp.of(KLabelConstant.of("'checkSat", this.context), implication);
            implication = KApp.of(KLabelConstant.KEQ_KLABEL, checkSat, unsat);
            Rule newRule = new Rule(left, right, this.context);
            KApp cc = KApp.of(KLabelConstant.BOOL_ANDBOOL_KLABEL, cnd.shallowCopy(), implication);
            if (RLBackend.SIMPLIFY) {
                cc = KApp.of(KLabelConstant.of("'simplifyBool", this.context), cc);
            }
            newRule.setRequires(cc);
            newRule.setAttributes(node.getAttributes().shallowCopy());
            newRule = (Rule)newRule.accept(new MakeFreshVariables(this.context, fresh));
            return newRule;
        }
        return super.transform(node);
    }
}

