/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.kcheck.utils;

import java.util.ArrayList;
import java.util.List;
import org.kframework.kcheck.utils.AddCheckConstants;
import org.kframework.kcheck.utils.ExtractCellContent;
import org.kframework.kcheck.utils.ExtractPatternless;
import org.kframework.kcheck.utils.MakeFreshVariables;
import org.kframework.kcheck.utils.ReachabilityRuleKILParser;
import org.kframework.kcheck.utils.SetCellContent;
import org.kframework.kcheck.utils.VariablesVisitor;
import org.kframework.kil.ASTNode;
import org.kframework.kil.KSequence;
import org.kframework.kil.Rewrite;
import org.kframework.kil.Rule;
import org.kframework.kil.Term;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.BasicTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;

public class GeneratePrograms
extends BasicTransformer {
    private List<ASTNode> reachabilityRules;
    private List<Term> programs;

    public GeneratePrograms(Context context, List<ASTNode> reachabilityRules) {
        super("Generate reachability programs.", context);
        this.reachabilityRules = reachabilityRules;
        this.programs = new ArrayList<Term>();
    }

    @Override
    public ASTNode transform(Rule node) throws TransformerException {
        if (node.getAttribute("reachability-rule") != null && node.getBody() instanceof Rewrite) {
            Rewrite rewrite = (Rewrite)node.getBody();
            int rIndex = Integer.parseInt(node.getAttribute("reachability-rule"));
            ASTNode rrule = this.reachabilityRules.get(rIndex);
            ReachabilityRuleKILParser parser = new ReachabilityRuleKILParser(this.context);
            rrule.accept(parser);
            Term cnd = node.getRequires().shallowCopy();
            ExtractPatternless ep = new ExtractPatternless(this.context, true);
            cnd = (Term)cnd.accept(ep);
            Term left = rewrite.getLeft();
            Term right = rewrite.getRight();
            ExtractCellContent ecc = new ExtractCellContent(this.context, "k");
            left.accept(ecc);
            KSequence kseq = (KSequence)ecc.getContent();
            List<Term> contents = kseq.getContents();
            ArrayList<Term> newContents = new ArrayList<Term>();
            newContents.add(contents.get(0).shallowCopy());
            Term pgmprime = contents.get(1).shallowCopy();
            newContents.add(contents.get(2).shallowCopy());
            KSequence newSeq = new KSequence(newContents);
            Term newLeft = left.shallowCopy();
            newLeft = (Term)newLeft.accept(new SetCellContent(this.context, newSeq, "k"));
            Term newRight = right.shallowCopy();
            Rule newRule = new Rule(newLeft, newRight, this.context);
            newRule.setRequires(cnd);
            newRule.setAttributes(node.getAttributes().shallowCopy());
            Term newPgm = left.shallowCopy();
            Term implies = AddCheckConstants.getFreshImplicationForPgm(rIndex, this.context);
            ArrayList<Term> cnt = new ArrayList<Term>();
            cnt.add(pgmprime);
            cnt.add(implies);
            KSequence newContent = new KSequence(cnt);
            SetCellContent scc = new SetCellContent(this.context, newContent, "k");
            newPgm = (Term)newPgm.accept(scc);
            SetCellContent setpc = new SetCellContent(this.context, ep.getPhi(), "path-condition");
            newPgm = (Term)newPgm.accept(setpc);
            VariablesVisitor vvleft = new VariablesVisitor(this.context);
            parser.getPi().accept(vvleft);
            MakeFreshVariables mfv = new MakeFreshVariables(this.context, vvleft.getVariables());
            newPgm = (Term)newPgm.accept(mfv);
            this.programs.add(newPgm);
            return newRule;
        }
        return super.transform(node);
    }

    public List<Term> getPrograms() {
        return this.programs;
    }
}

