/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.kcheck.utils;

import java.util.LinkedList;
import org.kframework.kcheck.utils.ExtractCellContent;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Cell;
import org.kframework.kil.Map;
import org.kframework.kil.MapItem;
import org.kframework.kil.Term;
import org.kframework.kil.Variable;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.CopyOnWriteTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;

public class MergeToTransformer
extends CopyOnWriteTransformer {
    private Term toMerge;

    public MergeToTransformer(Context context, Term toMerge) {
        super("Left merge of a term into accepting term", context);
        this.toMerge = toMerge;
    }

    @Override
    public ASTNode transform(Cell node) throws TransformerException {
        ExtractCellContent ecc = new ExtractCellContent(this.context, node.getLabel());
        this.toMerge.accept(ecc);
        Term lcontent = ecc.getContent();
        if (lcontent != null) {
            String sort = node.getContents().getSort();
            Cell newCell = node.shallowCopy();
            if (this.context.isSubsortedEq("K", sort)) {
                newCell.setContents(lcontent);
                return newCell;
            }
            if (sort.equals("Map")) {
                Map rmap = (Map)node.getContents();
                Map lmap = (Map)lcontent;
                LinkedList<Term> terms = new LinkedList<Term>();
                for (Term term : rmap.getContents()) {
                    terms.add(term);
                }
                for (Term term : lmap.getContents()) {
                    if (term instanceof Variable || !(term instanceof MapItem)) continue;
                    MapItem mapItem = (MapItem)term;
                    Term texist = null;
                    for (Term t : terms) {
                        if (!((MapItem)t).getKey().equals(mapItem.getKey())) continue;
                        texist = t;
                    }
                    if (texist != null) {
                        terms.remove(texist);
                    }
                    terms.add(term);
                }
                newCell.setContents(new Map(terms));
                return newCell;
            }
        }
        return super.transform(node);
    }
}

