/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.kil;

import aterm.ATermAppl;
import aterm.ATermInt;
import aterm.ATermList;
import java.io.Serializable;
import java.util.Set;
import org.kframework.compile.utils.SyntaxByTag;
import org.kframework.kil.Attribute;
import org.kframework.kil.Attributes;
import org.kframework.kil.Production;
import org.kframework.kil.loader.Constants;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.Transformable;
import org.kframework.kil.visitors.Visitable;
import org.w3c.dom.Element;

public abstract class ASTNode
implements Visitable,
Transformable,
Serializable {
    private static final long serialVersionUID = 1L;
    protected Attributes attributes;

    public ASTNode(Element elem) {
        this.setLocation(elem);
    }

    public ASTNode(ATermAppl elem) {
        this.setLocation(elem);
    }

    private static String getElementLocation(Element elem) {
        if (elem != null && elem.hasAttribute("loc")) {
            return elem.getAttribute("loc");
        }
        return "generated";
    }

    private static String getElementFile(Element elem) {
        if (elem != null && elem.hasAttribute("loc")) {
            return elem.getAttribute("filename");
        }
        return "File System";
    }

    public ASTNode(ASTNode astNode) {
        this.attributes = astNode.attributes;
    }

    public ASTNode() {
        this("generated", "File System");
    }

    public ASTNode(String loc, String file) {
        this.setLocation(loc);
        this.setFilename(file);
    }

    protected void setLocation(Element elem) {
        this.setLocation(ASTNode.getElementLocation(elem));
        this.setFilename(ASTNode.getElementFile(elem));
    }

    protected void setLocation(ATermAppl elem) {
        ATermList list = (ATermList)elem.getAnnotations().getFirst();
        list = list.getNext();
        String filename = ((ATermAppl)list.getFirst().getChildAt(0)).getName();
        ATermAppl atm = (ATermAppl)list.getFirst().getChildAt(1);
        int loc0 = ((ATermInt)atm.getChildAt(0)).getInt();
        int loc1 = ((ATermInt)atm.getChildAt(1)).getInt() + 1;
        int loc2 = ((ATermInt)atm.getChildAt(2)).getInt();
        int loc3 = ((ATermInt)atm.getChildAt(3)).getInt() + 1;
        String loc = "(" + loc0 + "," + loc1 + "," + loc2 + "," + loc3 + ")";
        this.setLocation(loc);
        this.setFilename(filename);
    }

    public String getLocation() {
        return this.getAttribute("location");
    }

    public void setLocation(String loc) {
        this.putAttribute("location", loc);
    }

    public String getFilename() {
        return this.getAttribute("filename");
    }

    public void setFilename(String file) {
        this.putAttribute("filename", file);
    }

    public void addAttribute(String key, String val) {
        this.addAttribute(new Attribute(key, val));
    }

    public void addAttribute(Attribute attr) {
        if (this.attributes == null) {
            this.attributes = new Attributes();
        }
        this.attributes.contents.add(attr);
    }

    public boolean containsAttribute(String key) {
        return this.containsAttribute(key, false);
    }

    public boolean containsAttribute(String key, boolean prefix) {
        if (this.attributes == null) {
            return false;
        }
        return this.attributes.containsKey(key, prefix);
    }

    public String getAttribute(String key) {
        return this.getAttribute(key, false);
    }

    public String getAttribute(String key, boolean prefix) {
        String defaultValue = Constants.defaultAttributeValues.get(key);
        if (this.attributes == null) {
            return defaultValue;
        }
        String value = this.attributes.get(key, prefix);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public void putAttribute(String key, String val) {
        String defaultValue = Constants.defaultAttributeValues.get(key);
        if (val.equals(defaultValue)) {
            if (this.getAttribute(key).equals(defaultValue)) {
                return;
            }
            this.attributes.remove(key);
            return;
        }
        if (this.attributes == null) {
            this.attributes = new Attributes();
        }
        this.attributes.set(key, val);
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Attributes attrs) {
        this.attributes = attrs;
    }

    public Set<Production> getSyntaxByTag(String key, Context context) {
        return SyntaxByTag.get(this, key, context);
    }

    public abstract ASTNode shallowCopy();
}

