/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.kil;

import org.kframework.kil.ASTNode;
import org.kframework.kil.visitors.Transformer;
import org.kframework.kil.visitors.Visitor;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.w3c.dom.Element;

public class Attribute
extends ASTNode {
    public static final String BUILTIN_KEY = "builtin";
    public static final String FUNCTION_KEY = "function";
    public static final String PREDICATE_KEY = "predicate";
    public static final String HOOK_KEY = "hook";
    public static final String MACRO_KEY = "macro";
    public static final String SIMPLIFICATION_KEY = "simplification";
    public static final Attribute BRACKET = new Attribute("bracket", "");
    public static final Attribute FUNCTION = new Attribute("function", "");
    public static final Attribute PREDICATE = new Attribute("predicate", "");
    public static final Attribute ANYWHERE = new Attribute("anywhere", "");
    public static final Attribute EQUALITY = new Attribute("equality", "");
    public static final String CELL_KEY = "cell";
    private String key;
    private String value;

    public Attribute(String key, String value) {
        this.key = key;
        this.value = value;
    }

    public Attribute(Element elm) {
        super(elm);
        this.key = elm.getAttribute("key");
        this.value = elm.getAttribute("value");
    }

    public Attribute(Attribute attribute) {
        super(attribute);
        this.key = attribute.key;
        this.value = attribute.value;
    }

    public String toString() {
        return " " + this.getKey() + "(" + this.getValue() + ")";
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ASTNode accept(Transformer transformer) throws TransformerException {
        return transformer.transform(this);
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public Attribute shallowCopy() {
        return new Attribute(this);
    }
}

