/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.kil;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Attribute;
import org.kframework.kil.loader.JavaClassesFactory;
import org.kframework.kil.visitors.Transformer;
import org.kframework.kil.visitors.Visitor;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.utils.xml.XML;
import org.w3c.dom.Element;

public class Attributes
extends ASTNode {
    protected List<Attribute> contents;

    public Attributes(Attributes c) {
        super(c);
        this.contents = c.contents;
    }

    public Attributes(String location, String filename) {
        super(location, filename);
        this.contents = new ArrayList<Attribute>();
    }

    public Attributes(Element element) {
        super(element);
        this.contents = new ArrayList<Attribute>();
        List<Element> children = XML.getChildrenElements(element);
        for (Element e : children) {
            this.contents.add((Attribute)JavaClassesFactory.getTerm(e));
        }
    }

    public Attributes() {
        this.contents = new ArrayList<Attribute>();
    }

    public String toString() {
        if (this.isEmpty()) {
            return "";
        }
        String content = "[";
        for (Attribute t : this.contents) {
            content = content + t + ", ";
        }
        return content.substring(0, content.length() - 2) + "]";
    }

    public boolean containsKey(String key) {
        return this.containsKey(key, false);
    }

    public boolean containsKey(String key, boolean prefix) {
        if (this.contents == null) {
            return false;
        }
        for (Attribute attr : this.contents) {
            if (!(prefix ? attr.getKey().startsWith(key) : attr.getKey().equals(key))) continue;
            return true;
        }
        return false;
    }

    public Attribute getAttributeByKey(String key) {
        return this.getAttributeByKey(key, false);
    }

    public Attribute getAttributeByKey(String key, boolean prefix) {
        for (Attribute attr : this.contents) {
            if (!(prefix ? attr.getKey().startsWith(key) : attr.getKey().equals(key))) continue;
            return attr;
        }
        return null;
    }

    public String get(String key) {
        return this.get(key, false);
    }

    public String get(String key, boolean prefix) {
        for (Attribute attr : this.contents) {
            if (!(prefix ? attr.getKey().startsWith(key) : attr.getKey().equals(key))) continue;
            return attr.getValue();
        }
        return null;
    }

    public void set(String key, String value) {
        for (Attribute attr : this.contents) {
            if (!attr.getKey().equals(key)) continue;
            attr.setValue(value);
            return;
        }
        this.contents.add(new Attribute(key, value));
    }

    public void setAll(Attributes attrs) {
        for (Attribute attr : attrs.contents) {
            this.set(attr);
        }
    }

    public void set(Attribute attr) {
        Attribute oldAttr = this.getAttributeByKey(attr.getKey());
        if (oldAttr != null) {
            oldAttr.setValue(attr.getValue());
        } else {
            this.contents.add(attr.shallowCopy());
        }
    }

    public void remove(String key) {
        Iterator<Attribute> it = this.contents.iterator();
        while (it.hasNext()) {
            Attribute a = it.next();
            if (!a.getKey().equals(key)) continue;
            it.remove();
        }
    }

    public boolean isEmpty() {
        return this.contents.isEmpty();
    }

    public List<Attribute> getContents() {
        return this.contents;
    }

    public void setContents(List<Attribute> contents) {
        this.contents = contents;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ASTNode accept(Transformer transformer) throws TransformerException {
        return transformer.transform(this);
    }

    @Override
    public Attributes shallowCopy() {
        Attributes result = new Attributes();
        result.contents.addAll(this.contents);
        return result;
    }
}

