/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.kil;

import aterm.ATermAppl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Collection;
import org.kframework.kil.Term;
import org.kframework.kil.matchers.Matcher;
import org.kframework.kil.visitors.Transformer;
import org.kframework.kil.visitors.Visitor;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.w3c.dom.Element;

public class Bag
extends Collection {
    public static final Bag EMPTY = new Bag(Collections.emptyList());

    public Bag(String location, String filename) {
        super(location, filename, "Bag");
    }

    public Bag(Element element) {
        super(element);
    }

    public Bag(ATermAppl atm) {
        super(atm);
    }

    public Bag(Bag node) {
        super(node);
    }

    public Bag() {
        super("Bag");
    }

    public Bag(List<Term> col) {
        super("Bag", col);
    }

    public static Bag flatten(Bag bag) {
        Bag flatBag = bag.shallowCopy();
        flatBag.setContents(new ArrayList<Term>());
        Bag.flatten(flatBag.getContents(), bag.getContents());
        return flatBag;
    }

    public static void flatten(List<Term> flatBag, List<Term> nestedBag) {
        for (Term term : nestedBag) {
            if (term instanceof Bag) {
                Bag bag = (Bag)term;
                Bag.flatten(flatBag, bag.getContents());
                continue;
            }
            flatBag.add(term);
        }
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ASTNode accept(Transformer transformer) throws TransformerException {
        return transformer.transform(this);
    }

    @Override
    public void accept(Matcher matcher, Term toMatch) {
        matcher.match(this, toMatch);
    }

    @Override
    public Bag shallowCopy() {
        return new Bag(this);
    }
}

