/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.kil;

import aterm.ATermAppl;
import org.kframework.kil.ASTNode;
import org.kframework.kil.KApp;
import org.kframework.kil.Term;
import org.kframework.kil.Token;
import org.kframework.kil.matchers.Matcher;
import org.kframework.kil.visitors.Transformer;
import org.kframework.kil.visitors.Visitor;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.w3c.dom.Element;

public class BoolBuiltin
extends Token {
    public static final String SORT_NAME = "#Bool";
    public static final String TRUE_STRING = "true";
    public static final String FALSE_STRING = "false";
    public static final BoolBuiltin TRUE_TOKEN = new BoolBuiltin(Boolean.TRUE);
    public static final BoolBuiltin FALSE_TOKEN = new BoolBuiltin(Boolean.FALSE);
    public static final KApp TRUE = KApp.of(TRUE_TOKEN, new Term[0]);
    public static final KApp FALSE = KApp.of(FALSE_TOKEN, new Term[0]);
    private final Boolean value;

    public static BoolBuiltin of(String value) {
        BoolBuiltin.checkValue(value);
        if (value.equals(TRUE_STRING)) {
            return TRUE_TOKEN;
        }
        return FALSE_TOKEN;
    }

    public static KApp kAppOf(String value) {
        BoolBuiltin.checkValue(value);
        if (value.equals(TRUE_STRING)) {
            return TRUE;
        }
        return FALSE;
    }

    private static void checkValue(String value) {
        assert (value.equals(TRUE_STRING) || value.equals(FALSE_STRING)) : "unexpected value " + value + " for a builtin bool token; expected one of " + "true" + " or " + "false";
    }

    private BoolBuiltin(Boolean value) {
        this.value = value;
    }

    protected BoolBuiltin(Element element) {
        super(element);
        String s = element.getAttribute("value");
        BoolBuiltin.checkValue(s);
        this.value = Boolean.valueOf(s);
    }

    protected BoolBuiltin(ATermAppl atm) {
        super(atm);
        String s = ((ATermAppl)atm.getArgument(0)).getName();
        BoolBuiltin.checkValue(s);
        this.value = Boolean.valueOf(s);
    }

    public Boolean booleanValue() {
        return this.value;
    }

    @Override
    public String tokenSort() {
        return SORT_NAME;
    }

    @Override
    public String value() {
        return this.value.toString();
    }

    @Override
    public void accept(Matcher matcher, Term toMatch) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTNode accept(Transformer transformer) throws TransformerException {
        return transformer.transform(this);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

