/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.kil;

import aterm.ATermAppl;
import aterm.ATermList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Bag;
import org.kframework.kil.Bracket;
import org.kframework.kil.Cast;
import org.kframework.kil.Term;
import org.kframework.kil.Variable;
import org.kframework.kil.loader.JavaClassesFactory;
import org.kframework.kil.matchers.Matcher;
import org.kframework.kil.visitors.Transformer;
import org.kframework.kil.visitors.Visitor;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.utils.StringUtil;
import org.kframework.utils.errorsystem.KException;
import org.kframework.utils.general.GlobalSettings;
import org.kframework.utils.xml.XML;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class Cell
extends Term {
    public static String SORT_ATTRIBUTE = "sort";
    String label;
    String endLabel;
    Term contents;
    Map<String, String> cellAttributes;

    public String getEndLabel() {
        return this.endLabel;
    }

    public void setEndLabel(String endLabel) {
        this.endLabel = endLabel;
    }

    public Cell(String location, String filename) {
        super(location, filename, "BagItem");
        this.cellAttributes = new HashMap<String, String>();
    }

    public Cell(Element element) {
        super(element);
        this.sort = "BagItem";
        this.label = element.getAttribute("label");
        this.endLabel = element.getAttribute("endLabel");
        this.contents = (Term)JavaClassesFactory.getTerm(XML.getChildrenElements(element).get(0));
        NamedNodeMap its = element.getAttributes();
        this.cellAttributes = new HashMap<String, String>();
        this.setEllipses(element.getAttribute("ellipses"));
        for (int i = 0; i < its.getLength(); ++i) {
            if (its.item(i).getNodeName().equals("filename") || its.item(i).getNodeName().equals("loc") || its.item(i).getNodeName().equals("sort") || its.item(i).getNodeName().equals("label") || its.item(i).getNodeName().equals("endLabel")) continue;
            this.cellAttributes.put(its.item(i).getNodeName(), StringUtil.unescapeK("\"" + its.item(i).getNodeValue() + "\""));
        }
    }

    public Cell(ATermAppl atm) {
        super(atm);
        this.sort = "BagItem";
        this.label = ((ATermAppl)atm.getArgument(0)).getName();
        boolean left = false;
        boolean right = false;
        ATermAppl next = (ATermAppl)atm.getArgument(2);
        if (next.getName().equals("LeftCell")) {
            left = true;
            next = (ATermAppl)next.getArgument(0);
        }
        if (next.getName().equals("RightCell")) {
            right = true;
            next = (ATermAppl)next.getArgument(0);
        }
        this.cellAttributes = new HashMap<String, String>();
        if (left && right) {
            this.setEllipses(Ellipses.BOTH);
        } else if (left) {
            this.setEllipses(Ellipses.LEFT);
        } else if (right) {
            this.setEllipses(Ellipses.RIGHT);
        } else {
            this.setEllipses(Ellipses.NONE);
        }
        ATermList list = (ATermList)atm.getArgument(1);
        while (!list.isEmpty()) {
            String key = ((ATermAppl)((ATermAppl)list.getFirst()).getArgument(0)).getName();
            String value = ((ATermAppl)((ATermAppl)list.getFirst()).getArgument(1)).getName();
            this.cellAttributes.put(key, StringUtil.unescapeK(value));
            list = list.getNext();
        }
        this.contents = (Term)JavaClassesFactory.getTerm(next);
        this.endLabel = ((ATermAppl)atm.getArgument(3)).getName();
    }

    public Cell(Cell node) {
        super(node);
        this.label = node.label;
        this.endLabel = node.endLabel;
        this.cellAttributes = node.cellAttributes;
        this.contents = node.contents;
    }

    public Cell() {
        super("BagItem");
        this.cellAttributes = new HashMap<String, String>();
    }

    public boolean hasRightEllipsis() {
        Ellipses e = this.getEllipses();
        return e == Ellipses.RIGHT || e == Ellipses.BOTH;
    }

    public boolean hasLeftEllipsis() {
        Ellipses e = this.getEllipses();
        return e == Ellipses.LEFT || e == Ellipses.BOTH;
    }

    public String toString() {
        String attributes = "";
        for (Map.Entry<String, String> entry : this.cellAttributes.entrySet()) {
            attributes = attributes + " " + entry.getKey() + "=\"" + entry.getValue() + "\"";
        }
        String content = "<" + this.label + attributes + ">";
        if (this.hasLeftEllipsis()) {
            content = content + "...";
        }
        content = content + " " + this.contents + " ";
        if (this.hasRightEllipsis()) {
            content = content + "...";
        }
        return content + "</" + this.label + "> ";
    }

    public String getLabel() {
        return this.label;
    }

    public Term getContents() {
        return this.contents;
    }

    public void setContents(Term contents) {
        this.contents = contents;
    }

    @Override
    public String getSort() {
        return this.sort;
    }

    @Override
    public void setSort(String sort) {
        this.sort = sort;
    }

    public Multiplicity getMultiplicity() {
        if (this.cellAttributes.containsKey("multiplicity")) {
            String attr = this.cellAttributes.get("multiplicity");
            if ("?".equals(attr)) {
                return Multiplicity.MAYBE;
            }
            if ("*".equals(attr)) {
                return Multiplicity.ANY;
            }
            if ("+".equals(attr)) {
                return Multiplicity.SOME;
            }
            if ("1".equals(attr)) {
                return Multiplicity.ONE;
            }
            GlobalSettings.kem.register(new KException(KException.ExceptionType.WARNING, KException.KExceptionGroup.COMPILER, "Unknown multiplicity in configuration for cell " + this.getLabel() + ".", this.getFilename(), this.getLocation()));
        }
        return Multiplicity.ONE;
    }

    public Ellipses getEllipses() {
        String attr = this.cellAttributes.get("ellipses");
        try {
            if (attr != null) {
                return Ellipses.valueOf(attr.toUpperCase());
            }
        }
        catch (IllegalArgumentException e) {
            String msg = "Unknown ellipses value in configuration for cell " + this.getLabel() + ". Assuming none.";
            GlobalSettings.kem.register(new KException(KException.ExceptionType.WARNING, KException.KExceptionGroup.COMPILER, msg, this.getFilename(), this.getLocation()));
        }
        return Ellipses.NONE;
    }

    public void setEllipses(String ellipses) {
        if ((ellipses = ellipses.toLowerCase()).isEmpty() || ellipses.equals("none")) {
            this.cellAttributes.remove("ellipses");
        } else {
            this.cellAttributes.put("ellipses", ellipses);
        }
    }

    public Map<String, String> getCellAttributes() {
        return this.cellAttributes;
    }

    public void setCellAttributes(Map<String, String> cellAttributes) {
        this.cellAttributes = cellAttributes;
    }

    public boolean containsCellAttribute(String attribute) {
        return this.cellAttributes.containsKey(attribute);
    }

    public String getCellAttribute(String attribute) {
        return this.cellAttributes.get(attribute);
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ASTNode accept(Transformer transformer) throws TransformerException {
        return transformer.transform(this);
    }

    @Override
    public void accept(Matcher matcher, Term toMatch) {
        matcher.match(this, toMatch);
    }

    public void setDefaultAttributes() {
        this.cellAttributes = new HashMap<String, String>();
    }

    @Override
    public Cell shallowCopy() {
        return new Cell(this);
    }

    public String getId() {
        String id = this.cellAttributes.get("id");
        if (null == id) {
            id = this.label;
        }
        return id;
    }

    public void setEllipses(Ellipses e) {
        this.setEllipses(e.toString());
    }

    public void setId(String id) {
        if (this.getId().equals(id)) {
            return;
        }
        this.cellAttributes.put("id", id);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Cell)) {
            return false;
        }
        Cell c = (Cell)o;
        return this.label.equals(c.label) && this.contents.equals(c.contents);
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Bracket) {
            return this.contains(((Bracket)o).getContent());
        }
        if (o instanceof Cast) {
            return this.contains(((Cast)o).getContent());
        }
        if (!(o instanceof Cell)) {
            return false;
        }
        Cell c = (Cell)o;
        return this.label.equals(c.label) && this.contents.contains(c.contents);
    }

    @Override
    public int hashCode() {
        return this.label.hashCode() * 17 + this.contents.hashCode();
    }

    public List<Term> getCellTerms() {
        Term contents = this.getContents();
        ArrayList<Term> cells = new ArrayList<Term>();
        if (contents instanceof Variable || contents instanceof Cell) {
            cells.add(contents);
        } else if (contents instanceof Bag) {
            cells.addAll(((Bag)contents).getContents());
        }
        return cells;
    }

    public static enum Ellipses {
        LEFT,
        RIGHT,
        BOTH,
        NONE;

    }

    public static enum Multiplicity {
        ONE,
        MAYBE,
        ANY,
        SOME;

    }
}

