/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.kil;

import aterm.ATermAppl;
import java.util.ArrayList;
import java.util.List;
import org.kframework.kil.Bracket;
import org.kframework.kil.Cast;
import org.kframework.kil.Term;
import org.kframework.kil.loader.JavaClassesFactory;
import org.kframework.utils.xml.XML;
import org.w3c.dom.Element;

public abstract class Collection
extends Term {
    protected List<Term> contents;

    public Collection(String sort) {
        super(sort);
        this.contents = new ArrayList<Term>();
    }

    public Collection(Collection c) {
        super(c);
        this.contents = new ArrayList<Term>(c.contents);
    }

    public Collection(String location, String filename, String sort) {
        super(location, filename, sort);
        this.contents = new ArrayList<Term>();
    }

    public Collection(Element element) {
        super(element);
        this.contents = new ArrayList<Term>();
        List<Element> children = XML.getChildrenElements(element);
        for (Element e : children) {
            this.contents.add((Term)JavaClassesFactory.getTerm(e));
        }
    }

    public Collection(ATermAppl atm) {
        super(atm);
        this.contents = new ArrayList<Term>();
        for (int i = 0; i < atm.getArity(); ++i) {
            this.contents.add((Term)JavaClassesFactory.getTerm(atm.getArgument(i)));
        }
    }

    public Collection(String sort, List<Term> col) {
        super(sort);
        this.contents = col;
    }

    public String toString() {
        String content = "";
        for (Term t : this.contents) {
            content = content + t;
        }
        if (content.equals("")) {
            return "." + this.sort;
        }
        return content;
    }

    public List<Term> getContents() {
        return this.contents;
    }

    public void setContents(List<Term> contents) {
        this.contents = contents;
    }

    public void add(Term t) {
        this.contents.add(t);
    }

    public boolean isEmpty() {
        return this.contents.isEmpty();
    }

    @Override
    public abstract Collection shallowCopy();

    @Override
    public boolean equals(Object o) {
        if (this.getClass() != o.getClass()) {
            return false;
        }
        Collection c = (Collection)o;
        return this.sort.equals(c.sort) && this.contents.equals(c.contents);
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Bracket) {
            return this.contains(((Bracket)o).getContent());
        }
        if (o instanceof Cast) {
            return this.contains(((Cast)o).getContent());
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        Collection c = (Collection)o;
        for (int i = 0; i < this.contents.size(); ++i) {
            if (this.contents.get(i).contains(c.contents.get(i))) continue;
            return false;
        }
        return this.sort.equals(c.sort);
    }

    @Override
    public int hashCode() {
        return this.sort.hashCode() * 13 + this.contents.hashCode();
    }
}

