/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.kil;

import java.util.Collection;
import java.util.Collections;
import org.kframework.kil.ASTNode;
import org.kframework.kil.DataStructureBuiltin;
import org.kframework.kil.DataStructureSort;
import org.kframework.kil.SetBuiltin;
import org.kframework.kil.Term;
import org.kframework.kil.visitors.Transformer;
import org.kframework.kil.visitors.Visitor;
import org.kframework.kil.visitors.exceptions.TransformerException;

public class CollectionBuiltin
extends DataStructureBuiltin {
    private final Collection<Term> elements;

    public CollectionBuiltin(DataStructureSort sort, Collection<Term> baseTerms, Collection<Term> elements) {
        super(sort, baseTerms);
        this.elements = elements;
    }

    public static CollectionBuiltin of(DataStructureSort sort, Collection<Term> baseTerms, Collection<Term> elements) {
        if (sort.type().equals("List")) {
            return new CollectionBuiltin(sort, baseTerms, elements);
        }
        return new SetBuiltin(sort, baseTerms, elements);
    }

    public Collection<Term> elements() {
        return Collections.unmodifiableCollection(this.elements);
    }

    @Override
    public boolean isEmpty() {
        return this.elements.isEmpty() && this.baseTerms.isEmpty();
    }

    @Override
    public Term shallowCopy() {
        return new CollectionBuiltin(this.dataStructureSort, this.baseTerms, this.elements);
    }

    @Override
    public int hashCode() {
        int hash = 1;
        hash = hash * 37 + super.hashCode();
        hash = hash * 37 + this.elements.hashCode();
        return hash;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CollectionBuiltin)) {
            return false;
        }
        CollectionBuiltin collectionBuiltin = (CollectionBuiltin)object;
        return super.equals(collectionBuiltin) && this.elements.equals(collectionBuiltin.elements);
    }

    @Override
    public ASTNode accept(Transformer transformer) throws TransformerException {
        return transformer.transform(this);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

