/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.kil;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.kframework.kil.ASTNode;
import org.kframework.kil.CollectionBuiltin;
import org.kframework.kil.DataStructureSort;
import org.kframework.kil.ListBuiltin;
import org.kframework.kil.MapBuiltin;
import org.kframework.kil.SetBuiltin;
import org.kframework.kil.Term;
import org.kframework.kil.Variable;
import org.kframework.kil.matchers.Matcher;
import org.kframework.kil.visitors.Transformer;
import org.kframework.kil.visitors.Visitor;
import org.kframework.kil.visitors.exceptions.TransformerException;

public abstract class DataStructureBuiltin
extends Term {
    protected final DataStructureSort dataStructureSort;
    protected final Variable viewBase;
    protected final Collection<Term> baseTerms;

    public static DataStructureBuiltin empty(DataStructureSort sort) {
        if (sort.type().equals("Bag") || sort.type().equals("Set")) {
            return new SetBuiltin(sort, Collections.emptyList(), Collections.emptyList());
        }
        if (sort.type().equals("List")) {
            return new ListBuiltin(sort, Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        }
        if (sort.type().equals("Map")) {
            return new MapBuiltin(sort, Collections.emptyList(), Collections.emptyMap());
        }
        assert (false) : "unknown collection type";
        return null;
    }

    public static DataStructureBuiltin element(DataStructureSort sort, Term ... argument) {
        if (sort.type().equals("Bag") || sort.type().equals("List") || sort.type().equals("Set")) {
            assert (argument.length == 1) : "unexpected number of collection item arguments; expected 1, found " + argument.length;
            if (sort.type().equals("List")) {
                ListBuiltin l = new ListBuiltin(sort, Collections.emptyList(), Collections.singletonList(argument[0]), Collections.emptyList());
                return l;
            }
            return new SetBuiltin(sort, Collections.emptyList(), Collections.singletonList(argument[0]));
        }
        if (sort.type().equals("Map")) {
            assert (argument.length == 2) : "unexpected number of map item arguments; expected 2, found " + argument.length;
            return new MapBuiltin(sort, Collections.emptyList(), Collections.singletonMap(argument[0], argument[1]));
        }
        assert (false) : "unknown collection type";
        return null;
    }

    public static DataStructureBuiltin of(DataStructureSort sort, Term ... argument) {
        if (sort.type().equals("Bag") || sort.type().equals("Set")) {
            ArrayList<Term> elements = new ArrayList<Term>();
            ArrayList<Term> terms = new ArrayList<Term>();
            for (Term term : argument) {
                if (term instanceof CollectionBuiltin) {
                    CollectionBuiltin collectionBuiltin = (CollectionBuiltin)term;
                    elements.addAll(collectionBuiltin.elements());
                    terms.addAll(collectionBuiltin.baseTerms());
                    continue;
                }
                terms.add(term);
            }
            return new SetBuiltin(sort, terms, elements);
        }
        if (sort.type().equals("List")) {
            ListBuiltin listBuiltin;
            int rightIndex;
            ListBuiltin listBuiltin2;
            int leftIndex;
            ArrayList<Term> elementsLeft = new ArrayList<Term>();
            ArrayList<Term> elementsRight = new ArrayList<Term>();
            ArrayList<Term> terms = new ArrayList<Term>();
            for (leftIndex = 0; leftIndex < argument.length && argument[leftIndex] instanceof ListBuiltin && (listBuiltin2 = (ListBuiltin)argument[leftIndex]).baseTerms().isEmpty(); ++leftIndex) {
                elementsLeft.addAll(listBuiltin2.elementsLeft());
                elementsLeft.addAll(listBuiltin2.elementsRight());
            }
            for (rightIndex = argument.length - 1; rightIndex > leftIndex && argument[rightIndex] instanceof ListBuiltin && (listBuiltin = (ListBuiltin)argument[rightIndex]).baseTerms().isEmpty(); --rightIndex) {
                for (Term element : listBuiltin.elementsRight()) {
                    elementsRight.add(0, element);
                }
                for (Term element : listBuiltin.elementsLeft()) {
                    elementsRight.add(0, element);
                }
            }
            if (leftIndex == rightIndex && argument[rightIndex] instanceof ListBuiltin) {
                listBuiltin = (ListBuiltin)argument[leftIndex];
                elementsLeft.addAll(listBuiltin.elementsLeft());
                for (Term element : listBuiltin.elementsRight()) {
                    elementsRight.add(0, element);
                }
            } else {
                terms.addAll(Arrays.asList(argument).subList(leftIndex, rightIndex + 1));
            }
            return ListBuiltin.of(sort, elementsLeft, elementsRight, terms);
        }
        if (sort.type().equals("Map")) {
            HashMap<Term, Term> elements = new HashMap<Term, Term>();
            ArrayList<Term> terms = new ArrayList<Term>();
            for (Term term : argument) {
                if (term instanceof MapBuiltin) {
                    MapBuiltin mapBuiltin = (MapBuiltin)term;
                    elements.putAll(mapBuiltin.elements());
                    terms.addAll(mapBuiltin.baseTerms());
                    continue;
                }
                terms.add(term);
            }
            return new MapBuiltin(sort, terms, elements);
        }
        assert (false) : "unknown collection type";
        return null;
    }

    protected DataStructureBuiltin(DataStructureSort sort, Collection<Term> baseTerms) {
        super(sort.name());
        Term term;
        this.dataStructureSort = sort;
        this.baseTerms = baseTerms;
        this.viewBase = baseTerms.size() == 1 ? ((term = baseTerms.iterator().next()) instanceof Variable && term.getSort().equals(sort.name()) ? (Variable)term : null) : null;
    }

    public Collection<Term> baseTerms() {
        return Collections.unmodifiableCollection(this.baseTerms);
    }

    public boolean hasViewBase() {
        return this.viewBase != null;
    }

    public boolean isElementCollection() {
        return this.baseTerms.isEmpty();
    }

    public abstract boolean isEmpty();

    public boolean isLHSView() {
        return this.viewBase != null || this.baseTerms.isEmpty();
    }

    public DataStructureSort sort() {
        return this.dataStructureSort;
    }

    public Variable viewBase() {
        assert (this.hasViewBase());
        return this.viewBase;
    }

    @Override
    public Term shallowCopy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int hashCode() {
        int hash = 1;
        hash = hash * 37 + this.sort.hashCode();
        hash = hash * 37 + this.baseTerms.hashCode();
        return hash;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DataStructureBuiltin)) {
            return false;
        }
        DataStructureBuiltin dataStructureBuiltin = (DataStructureBuiltin)object;
        return this.sort.equals(dataStructureBuiltin.sort) && this.baseTerms.equals(dataStructureBuiltin.baseTerms);
    }

    @Override
    public void accept(Matcher matcher, Term toMatch) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTNode accept(Transformer transformer) throws TransformerException {
        return transformer.transform(this);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

