/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.kil;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.kframework.kil.KApp;
import org.kframework.kil.KLabelConstant;
import org.kframework.kil.Term;
import org.kframework.kil.loader.Context;

public class DataStructureSort
implements Serializable {
    public static final Set<String> TYPES = ImmutableSet.of("Bag", "List", "Map", "Set");
    public static final Map<String, ImmutableMap<Label, String>> LABELS = ImmutableMap.of("Bag", ImmutableMap.of(Label.CONSTRUCTOR, "__", Label.ELEMENT, "BagItem", Label.UNIT, ".Bag"), "List", ImmutableMap.of(Label.CONSTRUCTOR, "__", Label.ELEMENT, "ListItem", Label.UNIT, ".List"), "Map", ImmutableMap.of(Label.CONSTRUCTOR, "__", Label.ELEMENT, "_|->_", Label.UNIT, ".Map"), "Set", ImmutableMap.of(Label.CONSTRUCTOR, "__", Label.ELEMENT, "SetItem", Label.UNIT, ".Set"));
    public static final String DEFAULT_LIST_SORT = "MyList";
    public static final String DEFAULT_MAP_SORT = "MyMap";
    public static final String DEFAULT_SET_SORT = "MySet";
    public static final String DEFAULT_LIST_LABEL = "'_List_";
    public static final String DEFAULT_LIST_ITEM_LABEL = "'MyListItem";
    public static final String DEFAULT_LIST_UNIT_LABEL = "'.MyList";
    public static final String DEFAULT_MAP_LABEL = "'_Map_";
    public static final String DEFAULT_MAP_ITEM_LABEL = "'_|->_";
    public static final String DEFAULT_MAP_UNIT_LABEL = "'.MyMap";
    public static final String DEFAULT_SET_LABEL = "'_Set_";
    public static final String DEFAULT_SET_ITEM_LABEL = "'MySetItem";
    public static final String DEFAULT_SET_UNIT_LABEL = "'.MySet";
    private final String name;
    private final String type;
    private final String constructorLabel;
    private final String elementLabel;
    private final String unitLabel;
    private final ImmutableMap<String, String> operatorLabels;

    public DataStructureSort(String name, String type, String constructorLabel, String elementLabel, String unitLabel, Map<String, String> operatorLabels) {
        assert (TYPES.contains(type)) : "unknown builtin collection type " + type;
        this.name = name;
        this.type = type;
        this.constructorLabel = constructorLabel;
        this.elementLabel = elementLabel;
        this.unitLabel = unitLabel;
        this.operatorLabels = ImmutableMap.copyOf(operatorLabels);
    }

    public String constructorLabel() {
        return this.constructorLabel;
    }

    public String elementLabel() {
        return this.elementLabel;
    }

    public String name() {
        return this.name;
    }

    public Map<String, String> operatorLabels() {
        return this.operatorLabels;
    }

    public String type() {
        return this.type;
    }

    public String unitLabel() {
        return this.unitLabel;
    }

    public static Term listOf(Context context, Term ... listItems) {
        DataStructureSort myList = context.dataStructureListSortOf(DEFAULT_LIST_SORT);
        if (listItems.length == 0) {
            return KApp.of(KLabelConstant.of(myList.unitLabel(), context), new Term[0]);
        }
        Term result = listItems[0];
        for (int i = 1; i < listItems.length; ++i) {
            result = KApp.of(KLabelConstant.of(myList.constructorLabel(), context), result, listItems[i]);
        }
        return result;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DataStructureSort)) {
            return false;
        }
        DataStructureSort ds = (DataStructureSort)o;
        return ds.name.equals(this.name) && ds.type.equals(this.type) && ds.unitLabel.equals(this.unitLabel) && ds.constructorLabel.equals(this.constructorLabel) && ds.elementLabel.equals(this.elementLabel) && ds.operatorLabels.equals(this.operatorLabels);
    }

    public int hashCode() {
        return (this.name + this.type + this.unitLabel + this.elementLabel + this.constructorLabel).hashCode() * 37 + this.operatorLabels.hashCode();
    }

    public static enum Label {
        CONSTRUCTOR,
        ELEMENT,
        UNIT;

    }
}

