/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.kil;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.kframework.compile.sharing.DataStructureSortCollector;
import org.kframework.compile.sharing.TokenSortCollector;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Configuration;
import org.kframework.kil.ConfigurationNotFound;
import org.kframework.kil.ConfigurationNotUnique;
import org.kframework.kil.DefinitionItem;
import org.kframework.kil.Module;
import org.kframework.kil.ModuleItem;
import org.kframework.kil.loader.AddConsesVisitor;
import org.kframework.kil.loader.CollectConfigCellsVisitor;
import org.kframework.kil.loader.CollectConsesVisitor;
import org.kframework.kil.loader.CollectLocationsVisitor;
import org.kframework.kil.loader.CollectPrioritiesVisitor;
import org.kframework.kil.loader.CollectStartSymbolPgmVisitor;
import org.kframework.kil.loader.CollectSubsortsVisitor;
import org.kframework.kil.loader.CollectVariableTokens;
import org.kframework.kil.loader.Context;
import org.kframework.kil.loader.CountNodesVisitor;
import org.kframework.kil.loader.JavaClassesFactory;
import org.kframework.kil.loader.UpdateAssocVisitor;
import org.kframework.kil.loader.UpdateReferencesVisitor;
import org.kframework.kil.visitors.Transformer;
import org.kframework.kil.visitors.Visitor;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.utils.errorsystem.KException;
import org.kframework.utils.general.GlobalSettings;
import org.kframework.utils.xml.XML;
import org.w3c.dom.Element;

public class Definition
extends ASTNode {
    private List<DefinitionItem> items;
    private String mainFile;
    private String mainModule;
    private Map<String, Module> modulesMap;
    private String mainSyntaxModule;

    public Definition() {
    }

    public Definition(Definition d) {
        super(d);
        this.mainFile = d.mainFile;
        this.mainModule = d.mainModule;
        this.mainSyntaxModule = d.mainSyntaxModule;
        this.items = d.items;
    }

    public Definition(Element element) {
        super(element);
        this.mainFile = element.getAttribute("mainFile");
        this.mainModule = element.getAttribute("mainModule");
        this.items = new ArrayList<DefinitionItem>();
        List<Element> elements = XML.getChildrenElements(element);
        for (Element e : elements) {
            this.items.add((DefinitionItem)JavaClassesFactory.getTerm(e));
        }
    }

    public String toString() {
        String content = "";
        for (DefinitionItem di : this.items) {
            content = content + di + " \n";
        }
        return "DEF: " + this.mainFile + " -> " + this.mainModule + "\n" + content;
    }

    public void setItems(List<DefinitionItem> items) {
        this.items = items;
    }

    public List<DefinitionItem> getItems() {
        return this.items;
    }

    public void setMainFile(String mainFile) {
        this.mainFile = mainFile;
    }

    public String getMainFile() {
        return this.mainFile;
    }

    public void setMainModule(String mainModule) {
        this.mainModule = mainModule;
    }

    public String getMainModule() {
        return this.mainModule;
    }

    public void setMainSyntaxModule(String mainSyntaxModule) {
        this.mainSyntaxModule = mainSyntaxModule;
    }

    public String getMainSyntaxModule() {
        return this.mainSyntaxModule;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ASTNode accept(Transformer transformer) throws TransformerException {
        return transformer.transform(this);
    }

    public void preprocess(Context context) {
        this.accept(new UpdateReferencesVisitor(context));
        this.accept(new AddConsesVisitor(context));
        this.accept(new UpdateAssocVisitor(context));
        this.accept(new CollectConsesVisitor(context));
        this.accept(new CollectSubsortsVisitor(context));
        this.accept(new CollectPrioritiesVisitor(context));
        this.accept(new CollectStartSymbolPgmVisitor(context));
        this.accept(new CollectConfigCellsVisitor(context));
        this.accept(new CollectLocationsVisitor(context));
        this.accept(new CountNodesVisitor(context));
        this.accept(new CollectVariableTokens(context));
        context.setTokenSorts(TokenSortCollector.collectTokenSorts(this, context));
        DataStructureSortCollector dataStructureSortCollector = new DataStructureSortCollector(context);
        this.accept(dataStructureSortCollector);
        context.setDataStructureSorts(dataStructureSortCollector.getSorts());
        context.initialized = true;
    }

    public Map<String, Module> getModulesMap() {
        return this.modulesMap;
    }

    public void setModulesMap(Map<String, Module> modulesMap) {
        this.modulesMap = modulesMap;
    }

    public Module getSingletonModule() {
        LinkedList<Module> modules = new LinkedList<Module>();
        for (DefinitionItem i : this.getItems()) {
            if (!(i instanceof Module)) continue;
            modules.add((Module)i);
        }
        if (modules.size() != 1) {
            String msg = "Should have been only one module when calling this method.";
            GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.INTERNAL, msg, this.getFilename(), this.getLocation()));
        }
        return (Module)modules.get(0);
    }

    @Override
    public Definition shallowCopy() {
        return new Definition(this);
    }

    public Configuration getSingletonConfiguration() throws ConfigurationNotUnique, ConfigurationNotFound {
        Configuration result = null;
        for (DefinitionItem i : this.getItems()) {
            if (!(i instanceof Module) || i.isPredefined()) continue;
            for (ModuleItem j : ((Module)i).getItems()) {
                if (!(j instanceof Configuration)) continue;
                if (result != null) {
                    throw new ConfigurationNotUnique();
                }
                result = (Configuration)j;
            }
        }
        if (result == null) {
            throw new ConfigurationNotFound();
        }
        return result;
    }
}

