/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.kil;

import aterm.ATermAppl;
import java.util.HashMap;
import java.util.Map;
import org.kframework.kil.ASTNode;
import org.kframework.kil.KApp;
import org.kframework.kil.Term;
import org.kframework.kil.Token;
import org.kframework.kil.matchers.Matcher;
import org.kframework.kil.visitors.Transformer;
import org.kframework.kil.visitors.Visitor;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.utils.StringUtil;
import org.w3c.dom.Element;

public class GenericToken
extends Token {
    private static Map<GenericToken, GenericToken> tokenCache = new HashMap<GenericToken, GenericToken>();
    private static Map<GenericToken, KApp> kAppCache = new HashMap<GenericToken, KApp>();
    private final String tokenSort;
    private final String value;

    public static GenericToken of(String sort, String value) {
        GenericToken genericToken = new GenericToken(sort, value);
        GenericToken cachedGenericToken = tokenCache.get(genericToken);
        if (cachedGenericToken == null) {
            cachedGenericToken = genericToken;
            tokenCache.put(genericToken, cachedGenericToken);
        }
        return cachedGenericToken;
    }

    public static KApp kAppOf(String sort, String value) {
        GenericToken genericToken = new GenericToken(sort, value);
        KApp kApp = kAppCache.get(genericToken);
        if (kApp == null) {
            kApp = KApp.of(genericToken, new Term[0]);
            kAppCache.put(genericToken, kApp);
        }
        return kApp;
    }

    private GenericToken(String sort, String value) {
        this.tokenSort = sort;
        this.value = value;
    }

    protected GenericToken(Element element) {
        super(element);
        this.tokenSort = element.getAttribute("sort");
        this.value = element.getAttribute("value");
    }

    protected GenericToken(ATermAppl atm) {
        super(atm);
        this.tokenSort = StringUtil.getSortNameFromCons(atm.getName());
        this.value = ((ATermAppl)atm.getArgument(0)).getName();
    }

    @Override
    public String tokenSort() {
        return this.tokenSort;
    }

    @Override
    public String value() {
        return this.value;
    }

    @Override
    public void accept(Matcher matcher, Term toMatch) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTNode accept(Transformer transformer) throws TransformerException {
        return transformer.transform(this);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

